var system=require("../../system")
const http=require("http")
const querystring = require('querystring');
var settings=require("../../../config/settings");
const AppletBase =require("../applet.base");
class invoiceApplet extends AppletBase{
   constructor(){
     super();
     this.invoiceService=system.getObject("service.invoiceSve");
     this.orderS=system.getObject("service.orderSve");
   }

   async crearInvoice(obj,req){
     var openid = obj.openid;
     if(openid==null||openid==""||openid=="undefined"){
       result.code=-101;
       result.msg="openid参数有误";
       return result;
     }
     if(obj.invoiceHeadUpType=="企业")
     {
       obj.invoiceHeadUpType="ent";
     }
     else {
       obj.invoiceHeadUpType="person";
     }

     if(obj.invoiceType=="纸质普通发票")
     {
       obj.invoiceType="zy";
     }
     else if(obj.invoiceType=="纸质专用发票") {
       obj.invoiceType="zs";
     }
     else {
        obj.invoiceType="pt";
     }
     var pobj={invoiceInfo:{
       invoiceType:obj.invoiceType,
       invoiceHeadUpType:obj.invoiceHeadUpType,
       invoiceHeadUpType2:obj.invoiceHeadUpType,
       invoiceHeadUp:obj.invoiceHeadUp,
       taxpayerID:obj.taxpayerID,
       applyAddr:obj.applyAddr,
       applytelephone:obj.applytelephone,
       bankAddrNum:obj.bankAddrNum,
       content:obj.content,
       mobile:obj.mobile,
       email:obj.email,
       address:obj.address,}};
     var userInfo =await this.cacheManager["AppletUserinfoCache"].get(openid);
     var user=JSON.parse(userInfo);
     if(user==null){
       return {code:-1,msg:"用户信息为空"}
     }
     if(pobj==null||pobj.invoiceInfo==null){
       return {code:-1,msg:"发票信息未填写完整"}
     }
     if(pobj.invoiceInfo.invoiceHeadUpType==null||pobj.invoiceInfo.invoiceHeadUpType==""){
       return {code:-1,msg:"请求信息类型为空"}
     }
     var orderinfo= await this.orderS.findOneByOrderNum(obj.orderNum);
     if( orderinfo ==null )
     {
       return {code:-1,msg:"数据操作失败"}
     }
     var result= await this.invoiceService.createOrUpdateInvoiceInfo(user,orderinfo,pobj);
     if(result==null){
       return {code:-1,msg:"数据操作失败"}
     }
     return {code:1,msg:"发票申请成功"};
   }

   async getInvoices(obj,req){
     console.log("---------------------getInvoices------------------------------");
     console.log(obj)
     var openid = obj.openid;
     var status=obj.status;
     var userInfo =await this.cacheManager["AppletUserinfoCache"].get(openid);
     userInfo=JSON.parse(userInfo);
     var result={
        code: 1,
        message: "success",
        data: []
     };
     if(userInfo=="null"||userInfo==null||userInfo=="undefined"){
       result.code=-104;
       result.message="用户信息有误";
       return result;
     }
     if(userInfo.onlyCode==null){
       result.code=-106;
       result.message="用户信息有误";
       return result;
     }
       var onlyCode=userInfo.onlyCode;
       var data={};
       if(obj.status=="all"){
         data={
           onlyCode:onlyCode
         };
       }else{
         data[this.db.Op.and]=[
           {onlyCode:onlyCode},
           {status:obj.status}
         ];
       }
       console.log("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
       console.log(data);
       try{
         var invoices = await this.invoiceService.findAllInvoices(data);
         console.log(invoices);
         return {
              code:1,
              message: "success",
              data: invoices
           };
       }catch (e){
         return {
              code: -200,
              message: "error",
              data: []
           };
       }
       console.log("---------------------getInvoices------end------------------------");
   }


}
module.exports=invoiceApplet;
