var system=require("../../system")
const http=require("http")
const querystring = require('querystring');
var settings=require("../../../config/settings");
const AppletBase =require("../applet.base");
const logCtl=system.getObject("web.oplogCtl");
class eSignBaoApplet extends AppletBase{
   constructor(){
     super();
     this.utilesignbaoSve=system.getObject("service.utilesignbaoSve");
     this.econtractSve=system.getObject("service.econtractSve");
   }
   //e签宝签署回调=post
   /*
    action：标记该通知的业务类型
    action=SIGN_FLOW_UPDATE，5.9.3	签署人签署状态更新通知，e签宝签署状态变化完成后调用（拒签、签署完成），签署人签署完成,调用e签宝归档流程
    action=SIGN_FLOW_FINISH，5.9.4	签署任务结束通知，由调用【**归档流程**】后回调此回调
   */
   async noticeCallback(obj,req){
     //日志记录
     logCtl.info({
        optitle:"e签宝签署回调信息info",
        op:"wxapplet/impl/esignbao/eSignBaoCallback",
        content:"请求参数："+req?JSON.stringify(req):"",
        clientIp:req.clientIp
      });
     var result={
        code: 1,
        message: "success",
        shopNum:"",
       data:{}
     };
     var action=req.action==null||req.action==""||req.action=="undefined"?"":req.action;
     var flowId=req.flowId==null||req.flowId==""||req.flowId=="undefined"?"":req.flowId;
     if(action==""||flowId==""){
       result.code=-101;
       result.message="请求参数有误";
       return result;
     }
     try {
       if(action!="SIGN_FLOW_FINISH"&&action!="SIGN_FLOW_UPDATE"){
         result.code=-102;
         result.message="action请求参数有误";
         return result;
       }
       var params = {
             flowId:flowId
            };
       var contractDetails=await this.utilesignbaoSve.getContractDetails(params,"eSignBaoApplet");
       if(action=="SIGN_FLOW_UPDATE"){   //5.9.3	签署人签署状态更新通知，e签宝签署状态变化完成后调用（拒签、签署完成）
         var signResultStatus=req.signResult==null||req.signResult==""||req.signResult=="undefined"?-1:req.signResult;
         if(signResultStatus>=0){
           // 跟进回调----更新db签署人签署状态
           this.econtractSve.updateCallbackStatus(req);
           if(signResultStatus==2){  //签署人签署完成,调用e签宝归档流程
             var archiveProcess=await this.utilesignbaoSve.archiveProcess(params,"eSignBaoApplet");
           }
         }
       }
       else if (action=="SIGN_FLOW_FINISH") {  //5.9.4	签署任务结束通知，由调用【**归档流程**】后回调此回调
         var flowStatus=req.flowStatus==null||req.flowStatus==""||req.flowStatus=="undefined"?-1:req.flowStatus;
         if(flowStatus>=0){
           //TODO:跟进回调----更新db签署流程状态
         }
       }
       return result;
     } catch (e) {
        console.log(e.stack);
        //日志记录
        logCtl.error({
           optitle:"e签宝签署回调异常error",
           op:"wxapplet/impl/esignbao/eSignBaoCallback",
           content:e.stack,
           clientIp:req.clientIp
         });
     }
   }

}
module.exports=eSignBaoApplet;
