
class MryzPriceDict {
    constructor() {
      this.items = [
        {"code" : "p1", "name" : "5万以内", min:0, max:50000},
        {"code" : "p2", "name" : "5-10万", min:50000, max:100000},
        {"code" : "p3", "name" : "10-20万", min:100000, max:200000},
        {"code" : "p4", "name" : "20-50万", min:200000, max:500000},
        {"code" : "p5", "name" : "50-100万", min:500000, max:1000000},
        {"code" : "p6", "name" : "100万以上", min:1000000, max:99999999999}
      ];
      this.itemMap = [];
      for(var i of this.items) {
        this.itemMap[i.code] = i;
      }
    }

    async getPriceDictList() {
      var list = [];
      for(var i of this.items) {
        list.push({"code":i.code, "name":i.name});
      }
      return list;
    }

    async getDict(code) {
      if(!code) {
        return;
      }
      return this.itemMap[code];
    }
}

module.exports = MryzPriceDict;
