const system = require("../system");
var moment = require('moment')
class ServiceBase {
  constructor(daoName) {
    //this.dbf=system.getObject("db.connection");
    this.db = system.getObject("db.connection").getCon();
    this.cacheManager = system.getObject("db.cacheManager");
    this.daoName = daoName;
    this.dao = system.getObject("db." + daoName);
  }
  static getDaoName(ClassObj) {
    return ClassObj["name"].substring(0, ClassObj["name"].lastIndexOf("Service")).toLowerCase() + "Dao";
  }
  async findAndCountAll(obj) {
    const apps = await this.dao.findAndCountAll(obj);
    return apps;
  }
  async refQuery(qobj) {
    return this.dao.refQuery(qobj);
  }
  async bulkDelete(ids) {
    var en = await this.dao.bulkDelete(ids);
    return en;
  }
  async delete(qobj) {
    return this.dao.delete(qobj);
  }
  async create(qobj) {
    return this.dao.create(qobj);
  }
  async update(qobj, tm = null) {
    return this.dao.update(qobj, tm);
  }
  async updateByWhere(setObj, whereObj, t) {
    return this.dao.updateByWhere(setObj, whereObj, t);
  }
  async customExecAddOrPutSql(sql, paras = null) {
    return this.dao.customExecAddOrPutSql(sql, paras);
  }
  async customQuery(sql, paras, t) {
    return this.dao.customQuery(sql, paras, t);
  }
  async findCount(whereObj = null) {
    return this.dao.findCount(whereObj);
  }
  async findSum(fieldName, whereObj = null) {
    return this.dao.findSum(fieldName, whereObj);
  }
  async getPageList(pageIndex, pageSize, whereObj = null, orderObj = null, attributesObj = null, includeObj = null) {
    return this.dao.getPageList(pageIndex, pageSize, whereObj, orderObj, attributesObj, includeObj);
  }
  async findOne(obj) {
    return this.dao.findOne(obj);
  }
  async findById(oid) {
    return this.dao.findById(oid);
  }
  /*
  返回20位业务订单号
  prefix：业务前缀
  */
  async getBusUid(prefix) {
    prefix = (prefix || "");
    if (prefix) {
      prefix = prefix.toUpperCase();
    }
    var prefixlength = prefix.length;
    var subLen = 8 - prefixlength;
    var uidStr = "";
    if (subLen > 0) {
      uidStr = await this.getUidInfo(subLen, 60);
    }
    var timStr = moment().format("YYYYMMDDHHmm");
    return prefix + timStr + uidStr;
  }
  /*
  len：返回长度
  radix：参与计算的长度，最大为62
  */
  async getUidInfo(len, radix) {
    var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
    var uuid = [], i;
    radix = radix || chars.length;
    if (len) {
      for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
    } else {
      var r;
      uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
      uuid[14] = '4';
      for (i = 0; i < 36; i++) {
        if (!uuid[i]) {
          r = 0 | Math.random() * 16;
          uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
        }
      }
    }
    return uuid.join('');
  }
  //钉钉消息推送（公司宝内部）
  async notifyDingTalkMsg(obj) {
    // var obj = {
    //   "content": "钉钉消息推送测试",
    //   "send_msg": "短信通知内容",
    //   "is_send": 1 - 发送通知短信，否则不通知,
    //   "order_no": "渠道订单号"
    // };
    var content = obj.content;
    var order_no = obj.order_no;
    if (!content || !order_no) {
      return { code: -1, mag: "参数错误" };
    }
    obj.op_type = obj.op_type || 1;//1为订单号发送短信跟钉钉，2为beehive系统中的业务员的手机号发送短信跟钉钉,order_no表示订单号或业务员手机号
    obj.customer_mobile = obj.customer_mobile || "";//customer_mobile为客户手机号用于发短信
    try {
      // obj["order_no"]="6020190312090381245";
      var reqUrl = "http://fq-api.gongsibao.com/openapi/dingtalk/sendMessageByOrderNo";
      var data = obj;
      var rc = system.getObject("util.execClient");
      var rtn = await rc.execPost(data, reqUrl);
      var result = JSON.parse(rtn.stdout);
      if (result && result.code == 200) {
        var resultdata = result.data;
        return { code: 1, msg: "success" };
      } else {
        return { code: -1, msg: "err" };
      }
    } catch (e) {
      // console.log(e);
      return { code: -1, msg: "error：" + e.stack };
    }
  }

}
module.exports = ServiceBase;
