const system = require("../../system");
const ServiceBase = require("../sve.base");
const moment = require('moment');
class WorkcrSubmitService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(WorkcrSubmitService));
    this.copyrightuserinfoDao = system.getObject("db.copyrightuserinfoDao");
    this.copyrightauthorDao = system.getObject("db.copyrightauthorDao");
  }
  async getAutoSubList() {
    var result =
    {
      code: 1,
      message: "success",
      data: {
        username: "汉唐信通（北京）登记注册代理事务所",
        password: "123456",
        order: []
      }
    };
    var sql = "SELECT s.*,u.name AS crName,u.`addrInfo` AS crAddrInfo,u.`zipCode` AS crZipCode,u.`customerContact` AS crCustomerContact," +
      "u.`tel` AS crTel,u.`email` AS crEmail,u.`mobile` AS crMobile,u.`fax` AS crFax,u.`entrustDesc` AS crEntrustDesc,a.`name` AS auName," +
      "a.`type` AS auType,a.`countryName` AS auCountryName,a.applyProvince AS auApplyProvince,a.`applyCity` AS auApplyCity,a.`certificateType` AS auCertificateType," +
      "a.`certificateCode` AS auCertificateCode,a.`garden` AS auGarden,a.`entType` AS auEntType,a.`sign_info` AS auSign_info,a.`alias_info` AS auAlias_info" +
      " FROM h_works_submit s LEFT JOIN h_copyright_userinfo u ON s.`orderNum`=u.`orderNum` LEFT JOIN h_copyright_author a ON s.`orderNum`=a.`orderNum`" +
      " WHERE s.`deleted_at` IS NULL AND s.statusProgress='COMMITED' LIMIT 200";
    var list = await this.customQuery(sql, null);
    if (!list || list.length == 0) {
      result.code = -100;
      result.message = "暂无提报数据";
      result.data = {};
      return result;
    }
    for (let index = 0; index < list.length; index++) {
      const item = list[index];
      if (item) {
        //作者姓名或名称以及作品署名
        var authorData = [];
        if (item.authorData && item.authorData != "undefined") {
          authorData = JSON.parse(item.authorData);
        }
        var tmpBase = {
          proxyCode:item.proxyCode,
          base: {
            opusName: item.name,//IGirl系列
            opusType: item.compositionTypeName,//图形,
            opusTypeDesc: item.compositionTypeDesc || "",
            authorData: authorData,
            opusInditeKind: "原创",
            opusDesc: item.opusDesc || "",
            createDate: moment(item.opusCreateDate).format('YYYY-MM-DD'),
            createCountry: item.finishCountry,
            createCity: item.finishCity,
            publishStatus: item.isPublish == 1 ? "已发表" : "未发表",//已发表,
            publishState: {//  --- 已发表信息
              appearDate: item.isPublish == "1" ? moment(item.publishedDate).format('YYYY-MM-DD') : "",
              appearCountry: item.isPublish == "1" ? item.publishedCountryName : "",
              appearCity: item.isPublish == "1" ? item.publishedCityName : ""
            },
            obtainMode: item.obtainModeName,//"原始",
            inheritDesc: item.obtainMode != "ys" ? item.inheritDesc || "" : "",//权利取得方式说明,
            rightOwnMode: item.rightOwnModeName,//法人作品,
            rightOwnDesc: item.rightOwnDesc || "",
            rightScope: item.rightScopeName,//部分,
            rightScope_: [],//发表权, 广播权, 改编权, 展览权,
            ownPartDesc: item.ownPartDesc || "",
            emedium: item.emedium,//-- - 电子介质
            ecount: item.ecount,
            pmedium: item.pmedium,//---- 纸 介 质
            pcount: item.pcount,//1,
            copyrighterMessage: {
              copyrighter: "否",//我是著作权人按钮
              personData: [
                {
                  name: item.auName,//汉唐信通（北京）咨询股份有限公司,
                  peopleType: item.auType,//企业法人,
                  country: item.auCountryName,//中国,
                  province: item.auApplyProvince,// 北京,
                  city: item.auApplyCity,//北京,
                  idTypes: item.auCertificateType,//企业法人营业执照,
                  idNumber: item.auCertificateCode,//911101057889696760,
                  sign: item.auSign_info,//-- - 本名
                  aliasInfo: item.auAlias_info//别名为XXX,
                }
              ]
            },
            applyType: "由代理人申请", //----申请办理方式
            proposer: {
              isProposer: "否",// --- 标识是否用登录账号的数据
              sqrname: "",//申请人姓名,
              sqraddress: "",//申请人地址,
              sqrpostCode: "",//申请人邮政编码,
              sqrcontactPerson: "",// 申请联系人,
              sqrphone: "",//申请人电话号码,
              sqremail: "",//申请人邮箱,
              sqrmobile: "",//申请人手机号码,
              sqrfax: ""//申请人传真号码
            },
            proxy: {
              isProxy: "是",
              agentDesc: item.crEntrustDesc,
              dlrname: item.crName,//申请人姓名,
              dlraddress: item.crAddrInfo,//申请人地址,
              dlrpostCode: item.crZipCode,//申请人邮政编码,
              dlrcontactPerson: item.crCustomerContact,// 申请联系人,
              dlrphone: item.crTel,//申请人电话号码,
              dlremail: item.crEmail,//申请人邮箱,
              dlrmobile: item.crMobile,//申请人手机号码,
              dlrfax: item.crFax || ""//申请人传真号码
            }
          }
        }
        result.data.order.push(tmpBase);
      }
    }
    return result;
  }

}
module.exports = WorkcrSubmitService;
