var System=require("../../system");
var settings=require("../../../config/settings");
const logCtl=System.getObject("web.oplogCtl");
//工商查询操作
class UtilsIcService{
  constructor(){
    this.iccompanynameSearchUrl=settings.apiconfig.iccompanynameSearchUrl(settings.env);
  }
  /*商标查询参数(company_name:公司名称、query_type:like模糊查找，jq精确查找、page_size:每页大小、current_page:当前第几页，从1开始)
  auther:sy
  返回值：
  {
    "status": 0,
    "msg": "操作成功",
    "total": 2,
    "data": [
        {
			"company_type": null,
			"legal_person": null,
			"reg_number": null,
			"reg_capital": null,
			"reg_institute": null,
			"from_time": null,
			"estibish_time": null,
			"business_scope": null,
			"reg_status": null,
			"company_name": "发展有限公司",
			"reg_location":"朝阳区10号",
			"credit_code": null,
			"org_number": null,
			"approved_time": null,
			"to_time": null
        }
    ],
    "bizmsg": "empty"
}
返回值说明:status为0则为成功，否则为查询有误
company_name    公司名称
legal_person    法定代表人
reg_capital     注册资本
estibish_time   成立时间
reg_number      注册号
org_number      组织机构代码号
reg_location    注册地址
credit_code     统一社会信用代码
reg_status      公司状态
company_type    公司类型
business_scope  经营范围
from_time       营业开始时间
to_time			营业结束时间
approved_time   核准日期
reg_institute   登记机关
		"total"						  总条数
  */
  async icDetailsByCompanyName(obj,opName){
    var companyName=obj.company_name==null||obj.company_name==""||obj.company_name=="undefined"?"":obj.company_name;
    var queryType=obj.query_type==null||obj.query_type==""||obj.query_type=="undefined"?"jq":obj.query_type;
    var pagesize=obj.page_size==null||obj.page_size==""||obj.page_size=="undefined"?20:obj.page_size;
    if(pagesize>100){
      pagesize=20;
    }
    var from=obj.current_page==null||obj.current_page==""||obj.current_page=="undefined"?0:Number((obj.current_page-1)*pagesize);

    if(companyName==""){
      return System.getResult2(null,null,null,"公司名称不能空");
    }
    if(queryType=="jq"){
      pagesize=1;
      from=0;
    }
    companyName=await this.getConvertSemiangleStr(companyName);
    var reqUrl=this.iccompanynameSearchUrl;
    var params = {
         "query" : {},
         "from": from,
         "size": pagesize,
         "_source": [
           "company_name",
           "reg_status",
           "legal_person",
           "reg_capital",
           "estibish_time"
         ],
        "sort": [
          {
            "reg_capital": "desc"
          }
        ]
       };
       if(queryType=="like"){
         params.query={
             "bool": {
                 "must": [
                     {
                       "query_string": {
               					"default_field": "company_name",
               					"query": '\"'+ companyName + '\"'
               				  }
                     }
                 ]
             }
         };
       }else {
         params.query={"term":{"company_name.raw":companyName}};
         //返回值添加
         params._source.push("reg_location");
         params._source.push("reg_number");
         params._source.push("org_number");
         params._source.push("credit_code");
         params._source.push("reg_status");
         params._source.push("company_type");
         params._source.push("business_scope");
         params._source.push("from_time");
         params._source.push("to_time");
         params._source.push("approved_time");
         params._source.push("reg_institute");
       }
       return this.returnResult(params,reqUrl,opName,"icDetailsByCompanyName");
  }
  async getConvertSemiangleStr(str){
    var result = "";
    var len = str.length;
    for(var i=0;i<len;i++)
    {
        var cCode = str.charCodeAt(i);
        //全角与半角相差（除空格外）：65248（十进制）
        cCode = (cCode>=0xFF01 && cCode<=0xFF5E)?(cCode - 65248) : cCode;
        //处理空格
        cCode = (cCode==0x03000)?0x0020:cCode;
        result += String.fromCharCode(cCode);
    }
   return result;
  }
  async returnResult(params,reqUrl,opClassName,opMethod){
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(params,reqUrl);
      var j=JSON.parse(rtn.stdout);
      if(j.status!=undefined){
        //执行查询有错
        //日志记录
        logCtl.error({
           optitle:"ES查询工商信息opClassName="+opClassName+"，opMethod="+opMethod+"ES执行异常error",
           op:"base/service/impl/tmutilsSve.js",
           content:rtn.stdout,
           clientIp:""
         });
         return System.getResult2(null,null,null,"查询出错");
      }
      return System.getResult3(j.hits,null);
    }catch(e){
      //日志记录
      logCtl.error({
         optitle:"ES查询工商信息opClassName="+opClassName+"，opMethod="+opMethod+"操作异常异常error",
         op:"base/service/impl/utilsicSve.js",
         content:e.stack,
         clientIp:""
       });
      return System.getResult2(null,null,null,"查询异常");
    }
  }
}
module.exports=UtilsIcService;
