var System = require("../../system");
var settings = require("../../../config/settings");
const logCtl = System.getObject("web.oplogCtl");
//工商查询操作
class utilsEntImageSve {
  constructor() {
    this.appDao = System.getObject("db.appDao");
  }
  async getEntInfo(mobile) {
    return await this.get_ent_customer(mobile);
  }
  async get_ent_customer(mobile) {
    var result = {
      code: 1, message: "success", data: {}
    }
    var sql = "SELECT * FROM `ent_customer` WHERE mobile=:mobile LIMIT 1 ";
    var param = { mobile: mobile };
    var list = await this.appDao.customQuery(sql, param);
    if (list == null || list.length == 0) {
      result.message = "无数据";
      result.data = {};
      return result;
    }
    var tmp_cognize_customer = [];
    if (list[0].cognize_customer) {
      var tmpStr = list[0].cognize_customer;
      tmp_cognize_customer = tmpStr.split(';');
    }
    //企业基础数据
    result.data.entInfo = {
      customer_num: list[0].mobile,//客户号
      act_age: list[0].act_age || 0,//账龄
      customer_grade: list[0].customer_grade || "",//客户等级
      channel_name: list[0].channel_name || "",//渠道名称
      channel_id: list[0].channel_id || 0,//渠道id
      followup_num: list[0].followup_num || 0,//跟进次数
      //后期处理数据
      customer_name: list[0].customer_name || "",//客户姓名
      ent_name: list[0].ent_name || "",//企业名称    
      wx_num: list[0].wx_num || 0,//微信营销次数(电话营销/2--电话营销)随机××××××××××××××××
      relevance_entnum: list[0].relevance_entnum || 0,// 关联企业数量
      ent_assess: list[0].ent_assess || 0,//企业实力评估数值
      credit_grade: list[0].credit_grade || "",//信用等级
      cognize_customer: tmp_cognize_customer,//30秒认知客户信息
      zc_total: list[0].zc_total || "",//无形资产数值
      tm_num: list[0].tm_num || "",//商标数量
      pa_num: list[0].pa_num || "",//专利数量
      cp_num: list[0].cp_num || ""//版权数量		
    };
    //客户经营信息
    result.data.customer_manage = list[0].customer_manage ? JSON.parse(list[0].customer_manage) : [];
    //购买历史
    result.data.buy_history = list[0].buy_history ? JSON.parse(list[0].buy_history) : [];

    //产品列表
    // "工商注册", "商标注册", "财税记账", "资质办理", "专利申请", "版权申请", "股权转让", "法律咨询"
    //购买产品  
    result.data.buy_product = list[0].buy_product ? JSON.parse(list[0].buy_product) : [];

    return result;
  }
}
module.exports = utilsEntImageSve;
