const system=require("../../system");
const ServiceBase=require("../sve.base");
class StatisticalRateService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(StatisticalRateService));
     this.accountDao=system.getObject("db.accountDao");
     this.pagestatisticsDao=system.getObject("db.pagestatisticsDao");
     this.userDao=system.getObject("db.userDao");
     this.shopDao=system.getObject("db.shopDao");
     this.orderDao=system.getObject("db.orderDao");
  }
  async getStatisticDataByType(obj){
    var type=obj.type;
    var myDate = new Date();
    var year = myDate.getFullYear();
    var month =myDate.getMonth() + 1;
    var day = myDate.getDate()-1;
    var tTime=year+"-"+month+"-"+day;
    var result=await this.accountDao.customQuery("SELECT * FROM `h_statistical_rate` WHERE createTime='"+tTime+"' and totalType ="+type);
    return result;
  }
  async getStatisticData(){
    var myDate = new Date();
    var year = myDate.getFullYear();
    var month =myDate.getMonth() + 1;
    var day = myDate.getDate()-1;
    var tTime=year+"-"+month+"-"+day;
    var result=await this.accountDao.customQuery("SELECT * FROM `h_statistical_rate` WHERE createTime='"+tTime + "' and totalType in ('zxbxl','kdl','yhfll')");
    return result;
  }
    async syncStatisticsData(){
      /* 咨询变现率=订单数量（已付款）/咨询数量(点击咨询电话)======？？？记录统计
      SELECT COUNT(id) FROM `h_order_info` WHERE orderSourceType='4' AND orderStatus='4'
      SELECT COUNT(id) FROM `h_page_statistics` WHERE statisticsCode='yddhzxtj'

      开店率=开店数量/合伙人（p_user 提交 app_id=9）
      SELECT COUNT(id) FROM `p_shop`
      SELECT COUNT(id) FROM `p_account`

      用户分裂率=有推荐码的用户数/用户数
      SELECT SUM(referrerOnlyCode IS NOT NULL)/COUNT(id) FROM `p_account`

      用户店铺分享率=店铺分享数（点击分享按钮）/店铺用户数（有推荐店铺码的用户）======？？？记录统计
      SELECT COUNT(id) FROM `h_page_statistics` WHERE statisticsCode='ydfxtj'
      SELECT COUNT(id) FROM `p_user` WHERE `concernShopOnlyCode` IS NULL*/
      var result={
         code: 1,
         message: "统计成功",
         data: {}
      };

      var myDate = new Date();
      var year = myDate.getFullYear();
      var month =myDate.getMonth() + 1;
      var day = myDate.getDate();
      var tTime=year+"-"+month+"-"+day;
      var addList=[];
      var queryCount=await this.dao.findCount({where:{createTime:tTime}});

      if(queryCount==0){
        //咨询变现率
        var zxfz=await this.orderDao.findCount({where:{orderSourceType:'4',orderStatus:'4'}});
        var zxfm=await this.pagestatisticsDao.findCount({where:{statisticsCode:'yddhzxtj'}});
        addList.push({
            createTime:tTime,
            totalType:'zxbxl',
            addUpMolecule:zxfz,//累计分子（包含以前所有数据）
            addUpDenominator:zxfm,//累计分母（包含以前所有数据）
            addUpValue:zxfm==0?0:parseFloat(zxfz)/parseFloat(zxfm)//累计值
        });
        //开店率
        var kdfz=await this.shopDao.findCount();
        var kdfm=await this.accountDao.findCount();
        addList.push({
            createTime:tTime,
            totalType:'kdl',
            addUpMolecule:kdfz,//累计分子（包含以前所有数据）
            addUpDenominator:kdfm,//累计分母（包含以前所有数据）
            addUpValue:kdfm==0?0:parseFloat(kdfz)/parseFloat(kdfm)//累计值
        });
        //用户分裂率  ,sql查询返回的值为：[ { tjCount: 0 } ]
        var flfz=await this.accountDao.customQuery("SELECT COUNT(1) tjCount FROM `p_account` WHERE referrerOnlyCode IS NOT NULL");
        addList.push({
            createTime:tTime,
            totalType:'yhfll',
            addUpMolecule:flfz[0].tjCount,//累计分子（包含以前所有数据）
            addUpDenominator:kdfm,//累计分母（包含以前所有数据）
            addUpValue:kdfm==0?0:parseFloat(flfz[0].tjCount)/parseFloat(kdfm)//累计值
        });
        // //用户店铺分享率
        // var fxfz=await this.pagestatisticsDao.findCount({where:{statisticsCode:'ydfxtj'}});
        // var fxfm=await this.userDao.findCount({where:{concernShopOnlyCode:null}});//  "SELECT COUNT(*) as fxCount FROM `p_user` WHERE concernShopOnlyCode IS NULL");
        // addList.push({
        //     createTime:tTime,
        //     totalType:'yhdpfxl',
        //     addUpMolecule:fxfz,//累计分子（包含以前所有数据）
        //     addUpDenominator:fxfm,//累计分母（包含以前所有数据）
        //     addUpValue:fxfm==0?0:parseFloat(fxfz)/parseFloat(fxfm)//累计值
        // });
        this.dao.model.bulkCreate(addList);
      }
      else {
        result.message="要统计的时期db中已经存在";
      }
      return result;
    }
}
module.exports=StatisticalRateService;
