const system = require("../../system");
const ServiceBase = require("../sve.base");
const moment = require('moment');
class SoftwarecrsubmitService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(SoftwarecrsubmitService));
    this.copyrightuserinfoDao = system.getObject("db.copyrightuserinfoDao");
    this.copyrightauthorDao = system.getObject("db.copyrightauthorDao");
  }
  async getAutoSubList() {
    var result =
    {
      code: 1,
      message: "success",
      data: {
        username: "汉唐信通（北京）登记注册代理事务所",
        password: "123456",
        order: []
      }
    };
    var sql = "SELECT s.*,u.name AS crName,u.`addrInfo` AS crAddrInfo,u.`zipCode` AS crZipCode,u.`customerContact` AS crCustomerContact," +
      "u.`tel` AS crTel,u.`email` AS crEmail,u.`mobile` AS crMobile,u.`fax` AS crFax,u.`entrustDesc` AS crEntrustDesc,a.`name` AS auName," +
      "a.`type` AS auType,a.`countryName` AS auCountryName,a.applyProvince AS auApplyProvince,a.`applyCity` AS auApplyCity,a.`certificateType` AS auCertificateType," +
      "a.`certificateCode` AS auCertificateCode,a.`garden` AS auGarden,a.`entType` AS auEntType,a.`sign_info` AS auSign_info,a.`alias_info` AS auAlias_info" +
      " FROM h_software_submit s LEFT JOIN h_copyright_userinfo u ON s.`orderNum`=u.`orderNum` LEFT JOIN h_copyright_author a ON s.`orderNum`=a.`orderNum`" +
      " WHERE s.`deleted_at` IS NULL AND s.statusProgress='COMMITED' LIMIT 200";
    var list = await this.customQuery(sql, null);
    if (!list || list.length == 0) {
      result.code = -100;
      result.message = "暂无提报数据";
      result.data = {};
      return result;
    }
    for (let index = 0; index < list.length; index++) {
      const item = list[index];
      if (item) {
        var tmpBase = {
          proxyCode:item.proxyCode,
          base: {
            softFullName: item.softwareName,//----软件全称
            softForShort: item.softwareShortName, //--- 软件简称
            softNumber: item.typeNum,
            editionNumber: item.softwareVersion,
            developCircs: item.descTypeName, //----软件作品说明,原创
            developCircsExplain: "",//是修改、翻译或合成别人软件，且需要原权利人授权的,
            origSoftRegCircs: "",//原有软件已经登记,
            origRegisterNumber: "",//原登记号,
            origSoftModifyDescription: "",// 修改合成或翻译说明,
            completeDate: moment(item.devDate).format('YYYY-MM-DD'),// --- 开发完成日期
            publishStatus: item.isPublish == "1" ? "已发表" : "未发表",
            pubstate: {//  --- 已发表信息
              appearDate: item.isPublish == "1" ? moment(item.publishedDate).format('YYYY-MM-DD') : "",
              appearAreaCountry: item.isPublish == "1" ? item.publishedCountryName : "",
              appearAreaCity: item.isPublish == "1" ? item.publishedCityName : ""
            },
            developMode: item.devWayName,//开发方式
            rightMode: {
              rightObtainMode: item.getWayName,//权利取得方式
              inheritanceMode: "",//受让
              isSoftReg: "",//软件是否已登记
              regNumber: "",//原登记号
              isSoftChanged: "",//变更
              changeNumber: ""//变更或补充证明编号
            },
            rightScope: item.rangeTypeName,// -- - 权利范围=权利范围1全部，2部分
            rightScope_: item.rangeType == "2" ? item.rangeTypePartInfo : "",// 署名权, ----权利范围选择部分后的选择的数组信息
            hardwareEnv: item.hardwareInfo,//硬件环境
            softwareEnv: item.softwareInfo,//软件环境
            programLanguage: item.programmingLanguage,//编程语言
            sourceCodeCapacity: item.sourceCodeCapacity,//源程序量
            softFunctionAndSpecialty: item.softFunctionAndSpecialty, //----主要功能和技术特点
            copyrighterMessage: {
              copyrighter: "否",//我是著作权人按钮
              personData: [
                {
                  name: item.auName,//汉唐信通（北京）咨询股份有限公司,
                  peopleType: item.auType,//企业法人,
                  country: item.auCountryName,//中国,
                  province: item.auApplyProvince,// 北京,
                  city: item.auApplyCity,//北京,
                  idTypes: item.auCertificateType,//企业法人营业执照,
                  idNumber: item.auCertificateCode,//911101057889696760,
                  garden: item.auGarden,//-- - 园区
                  busName: item.auEntType,//私营企业,
                  hasLetter: ""//--- 申请证书副本
                }
              ]
            },
            applyType: "由代理人申请", //----申请办理方式
            proposer: {
              isProposer: "否",// --- 标识是否用登录账号的数据
              sqrname: "",//申请人姓名,
              sqraddress: "",//申请人地址,
              sqrpostCode: "",//申请人邮政编码,
              sqrcontactPerson: "",// 申请联系人,
              sqrphone: "",//申请人电话号码,
              sqremail: "",//申请人邮箱,
              sqrmobile: "",//申请人手机号码,
              sqrfax: ""//申请人传真号码
            },
            proxy: {
              isProxy: "是",
              agentDesc: item.crEntrustDesc,
              dlrname: item.crName,//申请人姓名,
              dlraddress: item.crAddrInfo,//申请人地址,
              dlrpostCode: item.crZipCode,//申请人邮政编码,
              dlrcontactPerson: item.crCustomerContact,// 申请联系人,
              dlrphone: item.crTel,//申请人电话号码,
              dlremail: item.crEmail,//申请人邮箱,
              dlrmobile: item.crMobile,//申请人手机号码,
              dlrfax: item.crFax || ""//申请人传真号码
            },
            difmatReferMode: item.depositTypeName,
            isMutilDoc: item.isMutilDoc || "",//一种文档,
            mutilDocType: item.mutilDocType,//12, ----多种文档，种类为
            difmatReferModeExcep: "",//使用黑色宽斜线覆盖,
            difmatReferPages: ""//页码----使用黑色宽斜线覆盖，页码为XXX
          }
        }
        result.data.order.push(tmpBase);
      }
    }
    return result;
  }

}
module.exports = SoftwarecrsubmitService;
