const system=require("../../system");
const ServiceBase=require("../sve.base");
class ShopServiceItemService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(ShopServiceItemService));
     this.pconfigSve=system.getObject("service.pconfigSve");
     this.shopDao=system.getObject("db.shopDao");
     this.servicesitemDao=system.getObject("db.servicesitemDao");
     this.shopserviceitemDao=system.getObject("db.shopserviceitemDao");
     this.shopSve=system.getObject("service.shopSve");
     this.channelSve=system.getObject("service.channelSve");
  }
  async replenishServiceItem(channel){
      var result={
         code: 1,
         message: "补货成功",
         data: {}
      };
      var channelItem=await this.channelSve.getChannelItem(channel);
      if(channelItem==null){
        result.code="-100";
        result.message="所选择渠道有误，请确保渠道是发布状态";
      }
      var serviceItemList=await this.servicesitemDao.model.findAll({where:{channelCode:channel},raw:true});
      if(serviceItemList==null||serviceItemList.length==0){
          result.code="-101";
          result.message="数据为空";
      }
      if(channelItem.moreShop==1){
        return await this.moreShopReplenish(channelItem,serviceItemList,result);
      }else {
        return await this.oneShopReplenish(channelItem,serviceItemList,result);
      }
  }
  //支持开多店的渠道补货
  async moreShopReplenish(channelItem,serviceItemList,result){
    var self=this;
    var shopList=await this.shopSve.getShopList();
    return await this.opShopReplenish(shopList,channelItem,serviceItemList,result);
  }
  //不支持开多店的渠道补货
  async oneShopReplenish(channelItem,serviceItemList,result){
      var self=this;
      //不支持多店的
      var tmpUserChannel= await this.channelSve.getUserChannel(channelItem.id,null);
      if(tmpUserChannel==null||tmpUserChannel.length==0){
        result.message="亲，渠道信息不存在或未启用，请联系管理员";
        return result;
      }
      var arryUserIds=[];
      for (var i = 0; i < tmpUserChannel.length; i++) {
        var tmpItem=tmpUserChannel[i];
        if(tmpItem!=null){
          arryUserIds.push(tmpItem.user_id);
        }
      }
      var sqlWhere={where:{user_id:{[self.db.Op.in]: arryUserIds}},attributes:["id","app_id","user_id","onlyCode","userName","shopNum"],raw:true};
      var shopList=await this.shopDao.model.findAll(sqlWhere);
      return await this.opShopReplenish(shopList,channelItem,serviceItemList,result);
  }
  //店铺补货
  async opShopReplenish(shopList,channelItem,serviceItemList,result) {
    if(shopList==null||shopList.length==0){
      result.message="亲，店铺信息为空，请联系管理员";
      return result;
    }
    //添加店铺对应的服务项目列表
    var shopServiceItemList=[];
    //获取发票税率
    var tmpInvoiceTaxRate= await this.pconfigSve.getInvoiceTaxRate();
    var self=this;
    for (var i = 0; i < shopList.length; i++) {
          var shopItem=shopList[i];

          if(shopItem!=null)
          {
            //某一个店铺下某个渠道所有产品
            var sqlWhere={where:{shopNum:shopItem.shopNum,channelCode:channelItem.channelCode},attributes:["servicesitem_id"],raw:true};
            var queryShopServiceItemList=await self.dao.model.findAll(sqlWhere);
            if(queryShopServiceItemList!=null&&queryShopServiceItemList.length>=serviceItemList.length){
              continue;
            }
            //判断一个产品是否存在于渠道产品中
            for(var j = 0; j < serviceItemList.length; j++) {
                var tmpServiceItem=serviceItemList[j];
                if(tmpServiceItem!=null){
                  var oneLength=-1;
                  if(queryShopServiceItemList!=null&&queryShopServiceItemList.length>0){
                       oneLength=await queryShopServiceItemList.findIndex(function(value,index,arr){
                          return value.servicesitem_id==tmpServiceItem.id;
                        });
                  }
                  if(oneLength<0){
                    //店主提成金额
                    var tInvoiceTaxRate=await self.shopSve.setPushMoney(tmpServiceItem.guidePrice,tmpServiceItem.publicExpense,tmpServiceItem.platformCost,tmpServiceItem.platformProfitRatio,tmpInvoiceTaxRate,"platformWork");
                    //添加店铺对应的服务项目
                    var shopServiceItem={
                      shop_id:shopItem.id,
                      servicesitem_id:tmpServiceItem.id,
                      servicesitem_code:tmpServiceItem.code,

                      app_id:shopItem.app_id,
                      user_id:shopItem.user_id,
                      userName:shopItem.userName,
                      onlyCode:shopItem.onlyCode,
                      customTotalAmount:tmpServiceItem.guidePrice,//指导价
                      profitRatioTypeName:"委托作业",//分润类型名称
                      profitRatioType:"platformWork",//分润类型
                      customHotline:tmpServiceItem.hotline,//咨询电话
                      customNotes:tmpServiceItem.notes,//备注信息
                      pushMoney:tInvoiceTaxRate,//提成金额
                      shopNum:shopItem.shopNum,
                      itemType:tmpServiceItem.itemType,
                      channelCode:tmpServiceItem.channelCode
                    };
                    shopServiceItemList.push(shopServiceItem);
                  }
                }
              }
          }
      }
      if(shopServiceItemList.length>0){
         await self.shopserviceitemDao.model.bulkCreate(shopServiceItemList);
      }
      else {
         result.message="商家店铺服务项目已是最新，无需补货";
      }
      return result;
  }

  //操作用户发布的商标交易店铺补货
  async opTmTradeShopReplenish(serviceItem,result,t){
    var shopList=await this.shopSve.getShopList();
    if(shopList==null||shopList.length==0){
      result.code=-110;
      result.message="无需操作";
      return result;
    }
    //添加店铺对应的服务项目列表
    var shopServiceItemList=[];
    for (var i = 0; i < shopList.length; i++) {
        var shopItem=shopList[i];
        if(shopItem!=null)
        {
          //添加店铺对应的服务项目
          var shopServiceItem={
            shop_id:shopItem.id,
            servicesitem_id:serviceItem.id,
            servicesitem_code:serviceItem.code,
            app_id:shopItem.app_id,
            user_id:shopItem.user_id,
            userName:shopItem.userName,
            onlyCode:shopItem.onlyCode,
            customTotalAmount:serviceItem.guidePrice,//指导价
            profitRatioTypeName:"委托作业",//分润类型名称
            profitRatioType:"platformWork",//分润类型
            customHotline:serviceItem.hotline,//咨询电话---------在某个用户的店铺发布的商标交易，用的对应店铺的电话联系方式
            customNotes:serviceItem.notes,//备注信息
            pushMoney:0,//提成金额
            shopNum:shopItem.shopNum,
            itemType:serviceItem.itemType,
            channelCode:serviceItem.channelCode
          };
          shopServiceItemList.push(shopServiceItem);
        }
    }
    if(shopServiceItemList.length>0){
      if(t!=null && t!='undefined'){
        this.shopserviceitemDao.model.bulkCreate(shopServiceItemList,{transaction:t});
      }else {
        this.shopserviceitemDao.model.bulkCreate(shopServiceItemList);
      }
      result.message="操作成功";
    }else {
      result.message="无需操作";
    }
    return result;
  }
}
module.exports=ShopServiceItemService;
