const system=require("../../system");
const ServiceBase=require("../sve.base");
const settings=require("../../../config/settings");
const uuidv4 = require('uuid/v4');
class PatentinfoService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(PatentinfoService));
     this.orderDao=system.getObject("db.orderDao");
     this.orderflowDao=system.getObject("db.orderflowDao");
     this.partnerinfoDao=system.getObject("db.partnerinfoDao");
  }
  async getUUId(code){
    var tcode=code==null?"":code;
    var myDate=new Date();
    var uid=await this.getUidStr(8,60);
    return  tcode+""+myDate.getFullYear()+""+(myDate.getMonth()+1)+""+myDate.getDate()+""+myDate.getMilliseconds()+""+uid;
    // return  myDate.getFullYear()+""+myDate.getMonth()+""+myDate.getDate()+""+myDate.getHours()+""+myDate.getMinutes()+""+myDate.getSeconds()+""+myDate.getMilliseconds()+""+Math.round(Math.random()*500)+""+user.id;
  }
  async getUidStr(len, radix) {
      var chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'.split('');
      var uuid = [], i;
      radix = radix || chars.length;
      if (len) {
        for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random()*radix];
      } else {
        var r;
        uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
        uuid[14] = '4';
        for (i = 0; i < 36; i++) {
          if (!uuid[i]) {
            r = 0 | Math.random()*16;
            uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
          }
        }
      }
      return uuid.join('');
  }
  async findByIds(ids){
    var apps=await this.dao.findByIds(ids);
    return apps;
  }
  async findByCodes(codes){
    var apps=await this.dao.findByCodes(codes);
    return apps;
  }
  async findOneByCode(code){
    return this.dao.findOneByCode(code);
  }
 async findByOrderNum(orderNum){
   var apps=await this.dao.findByOrderNum(orderNum);
   return apps;
 }

 async aiadive(obj){
   var sql="select req from h_aiadive where search='"+ obj.seltype[0]+" / "+obj.seltype[1] + "'";
   var tmpResult=await this.dao.customQuery(sql);
   var nclinfo=[];
   tmpResult.forEach(n=>{
     nclinfo.push(n.req);
   })
   var info="{'ncl':["+nclinfo+"]}";
   var result=info.replace(/'/g,"\"");
   return result;
 }
 async hookOrder(obj){
   var self=this;
   return this.db.transaction(async function(t){
     var sql="update h_order_info set isHooked=1 where id=?";
     var params={replacements: [obj.oid],transaction:t};
     await self.dao.customExecAddOrPutSql(sql,params);
     var  ids=obj.cids;
     sql=`update h_patent_info set orderNum=?,status=?,statusName=? where id in ( ${ids} )`;
     params={replacements: [obj.orderNum,"2","已创建订单",obj.cids],transaction:t};
     var rtn=await self.dao.customExecAddOrPutSql(sql,params);
     return rtn;
   });
 }
 async changeStatus(obj){
   var ids = obj.ids;
   var status = obj.status;
   console.log(obj);
   var self = this;
   return this.db.transaction(async function(t){
     for(var i=0;i<ids.length;i++){
       await self.dao.update({id:ids[i],statusProgress:status},t);
     }
     return {code:1}
   })
 }
}
module.exports=PatentinfoService;
