const system=require("../../system");
const ServiceBase=require("../sve.base");
class PartnerInfoService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(PartnerInfoService));
     this.roleD=system.getObject("db.roleDao");
  }
  async getPartnerList(appId,userId){
    var whereStr={app_id:userInfo.app_id,user_id:userInfo.id};
    return this.dao.findPartnerList(whereStr);
  }
  async createPartner(userInfo,obj){
    var params={
      onlyCode:userInfo.onlyCode,
      cardNo:obj.cardNo,
      identityCard:obj.identityCard,
      realName:obj.realName,
    }
     var self=this;
     var tmpPartnerInfo= await self.dao.create(params);
     console.log("--------------------------tmpPartnerInfo");
     return tmpPartnerInfo;
  }
  async findpartnerinfo(onlyCode){
    var result=await this.dao.findOne(onlyCode);
    return result;
  }
  async createOrUpdatePartnerInfo(user,roleId,pobj){
        var self=this;
        return this.db.transaction(async function (t){
                var tmpPartnerInfo=null;
                var whereSql={where:{onlyCode:user.onlyCode}};
                var partnerItem= await self.dao.model.findOne(whereSql,t);
                if(partnerItem!=null){
                  partnerItem=partnerItem.get({plain:true});
                  //角色不同进行添加新角色
                  if(pobj.partnerInfo.apply_type!=partnerItem.applyType){
                    var sql="insert into `p_userrole` (`created_at`,`updated_at`,`user_id`,`role_id`) values (?,?,?,?)";
                    var tmpDate=new Date();
                    var params={replacements: [tmpDate,tmpDate,user.id,roleId],transaction:t};
                    await self.dao.customExecAddOrPutSql(sql,params);
                  }
                  partnerItem.applyType=pobj.partnerInfo.apply_type;
                  partnerItem.mobile=pobj.partnerInfo.mobile;
                  partnerItem.workPic=pobj.partnerInfo.workPic;
                  partnerItem.tagInfo=pobj.partnerInfo.tagInfo.join(",");
                  partnerItem.applyAddr=pobj.partnerInfo.apply_addr;
                  partnerItem.applyName=pobj.partnerInfo.apply_type!="person"?null:pobj.partnerInfo.applyName;
                  partnerItem.identityCardPic=pobj.partnerInfo.apply_type!="person"?null:pobj.partnerInfo.identityCardPic;
                  partnerItem.entName=pobj.partnerInfo.apply_type!="ent"?null:pobj.partnerInfo.entName;
                  partnerItem.businessLicensePic=pobj.partnerInfo.apply_type!="ent"?null:pobj.partnerInfo.businessLicensePic;
                  partnerItem.businessLicenseNum=pobj.partnerInfo.apply_type!="ent"?null:pobj.partnerInfo.businessLicenseNum;
                  partnerItem.identityCard=pobj.partnerInfo.identityCard;
                  partnerItem.cardNo=pobj.partnerInfo.cardNo;
                  partnerItem.realName=pobj.partnerInfo.realName;

                  await self.dao.update(partnerItem,t);
                  tmpPartnerInfo=partnerItem;
                }
                else {
                  //添加新角色
                  var sql="insert into `p_userrole` (`created_at`,`updated_at`,`user_id`,`role_id`) values (?,?,?,?)";
                  var tmpDate=new Date();
                  var params={replacements: [tmpDate,tmpDate,user.id,roleId],transaction:t};
                  await self.dao.customExecAddOrPutSql(sql,params);
                  //添加新合伙人
                  var reqParams={
                      app_id:user.app_id,
                      user_id:user.id,
                      onlyCode:user.onlyCode,
                      userName:user.userName,
                      applyType:pobj.partnerInfo.apply_type,
                      mobile:pobj.partnerInfo.mobile,
                      // tel:pobj.,
                      // email:pobj.mobile,
                      workPic:pobj.partnerInfo.workPic,
                      tagInfo:pobj.partnerInfo.tagInfo.join(","),
                      // applyProvince:DataTypes.STRING,
                      // applyCity:DataTypes.STRING,
                      // applyArea:DataTypes.STRING,
                      applyAddr:pobj.partnerInfo.apply_addr,
                      applyName:pobj.partnerInfo.apply_type!="person"?null:pobj.partnerInfo.applyName,
                      identityCardPic:pobj.partnerInfo.apply_type!="person"?null:pobj.partnerInfo.identityCardPic,
                      entName:pobj.partnerInfo.apply_type!="ent"?null:pobj.partnerInfo.entName,
                      businessLicensePic:pobj.partnerInfo.apply_type!="ent"?null:pobj.partnerInfo.businessLicensePic,
                      businessLicenseNum:pobj.partnerInfo.apply_type!="ent"?null:pobj.partnerInfo.businessLicenseNum,
                      identityCard:pobj.partnerInfo.identityCard,
                      cardNo:pobj.partnerInfo.cardNo,
                      realName:pobj.partnerInfo.realName
                  };

                  tmpPartnerInfo= await self.dao.create(reqParams,t);
                  tmpPartnerInfo=tmpPartnerInfo.get({plain:true});
                }
                return tmpPartnerInfo;
              });
       }
}
module.exports=PartnerInfoService;
