const system=require("../../system");
const ServiceBase=require("../sve.base");
class InvoiceService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(InvoiceService));
     this.orderDao=system.getObject("db.orderDao");
     //this.appDao=system.getObject("db.appDao");
  }
  async findAllInvoices(obj){
    return this.dao.model.findAll({where:obj,order:[["created_at","desc"]]});
  }

  async createOrUpdateInvoiceInfo(user,orderinfo,pobj){
        var self=this;
        return this.db.transaction(async function (t){
                var invoiceInfo=null;
                var whereSql={where:{orderNum:orderinfo.orderNum}};
                var invoiceItem= await self.dao.model.findOne(whereSql,t);
                if(invoiceItem!=null){
                  invoiceItem=invoiceItem.get({plain:true});
                  invoiceItem.totalServiceCharge=orderinfo.totalServiceCharge;
                  invoiceItem.totalPublicExpense=orderinfo.totalPublicExpense;
                  invoiceItem.totalPlatformCost=orderinfo.totalPlatformCost;
                  invoiceItem.totalInvoiceTaxes=orderinfo.totalInvoiceTaxes;
                  invoiceItem.totalSum=orderinfo.totalSum;
                  if(pobj.invoiceInfo.invoiceType!="zs"){
                    invoiceItem.invoiceHeadUpType=pobj.invoiceInfo.invoiceHeadUpType;
                  }else{
                    invoiceItem.invoiceHeadUpType=pobj.invoiceInfo.invoiceHeadUpType2;
                  };
                  invoiceItem.invoiceType=pobj.invoiceInfo.invoiceType;
                  if( pobj.invoiceInfo.invoiceHeadUpType == "ent" )
                  {
                    invoiceItem.invoiceHeadUp=pobj.invoiceInfo.invoiceHeadUp;
                    invoiceItem.taxpayerID=pobj.invoiceInfo.taxpayerID;
                  };
                  if(pobj.invoiceInfo.invoiceHeadUpType == "person"){
                    invoiceItem.invoiceHeadUp="个人";
                    invoiceItem.taxpayerID="";
                  }
                  invoiceItem.mobile=pobj.invoiceInfo.mobile;
                  invoiceItem.email=pobj.invoiceInfo.email;
                  invoiceItem.address=pobj.invoiceInfo.address;
                  invoiceItem.applyAddr=pobj.invoiceInfo.applyAddr;
                  invoiceItem.applytelephone=pobj.invoiceInfo.applytelephone;
                  invoiceItem.bankAddrNum=pobj.invoiceInfo.bankAddrNum;
                  invoiceItem.content=pobj.invoiceInfo.content;
                  await self.dao.update(invoiceItem,t);
                  invoiceInfo=invoiceItem;
                }
                else {
                  if( pobj.invoiceInfo.invoiceHeadUpType != "ent" )
                  {
                     pobj.invoiceInfo.invoiceHeadUp="个人";
                     pobj.invoiceInfo.taxpayerID="";
                  };
                  var a="";
                  if(pobj.invoiceInfo.invoiceType!="zs"){
                    a=pobj.invoiceInfo.invoiceHeadUpType;
                  }else{
                    a=pobj.invoiceInfo.invoiceHeadUpType2;
                  };
                  console.log(user);
                  var reqParams={
                      orderNum:orderinfo.orderNum,
                      app_id:user.app_id,
                      user_id:user.id,
                      onlyCode:user.onlyCode,
                      totalServiceCharge:orderinfo.totalServiceCharge,
                      totalPublicExpense:orderinfo.totalPublicExpense,
                      totalPlatformCost:orderinfo.totalPlatformCost,
                      totalInvoiceTaxes:orderinfo.totalInvoiceTaxes,
                      totalSum:orderinfo.totalSum,
                      invoiceHeadUpType:a,
                      invoiceType:pobj.invoiceInfo.invoiceType,
                      invoiceHeadUp:pobj.invoiceInfo.invoiceHeadUp,
                      mobile:pobj.invoiceInfo.mobile,
                      email:pobj.invoiceInfo.email,
                      taxpayerID:pobj.invoiceInfo.taxpayerID,
                      address:pobj.invoiceInfo.address,
                      applyAddr:pobj.invoiceInfo.applyAddr,
                      applytelephone:pobj.invoiceInfo.applytelephone,
                      bankAddrNum:pobj.invoiceInfo.bankAddrNum,
                      content:pobj.invoiceInfo.content
                  };
                  invoiceInfo= await self.dao.create(reqParams,t);
                  invoiceInfo=invoiceInfo.get({plain:true});
                  var setObj={invoiceApply:"applied"};
                  await self.orderDao.updateByWhere(setObj,whereSql,t);
                }
                return invoiceInfo;
              });
       }

}
module.exports=InvoiceService;
