const system=require("../../system");
const ServiceBase=require("../sve.base");
class EtemplateService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(EtemplateService));
     //this.appDao=system.getObject("db.appDao");

  }
  async findReadyContracts(obj){
    obj.isEnabled=true;
    let sql = "SELECT t1.*, t2.id AS companyid, t2.`name` AS companyname " +
              "FROM `c_etemplate` t1 " +
              "INNER JOIN c_ecompany t2 ON t1.`ecompany_id` = t2.id " +
              "WHERE t1.isEnabled = 1 AND t1.ecompany_id = :ecompany_id " +
              "AND t1.id NOT IN  (SELECT etemplate_id FROM `c_econtract` WHERE usereaccount_id = :usereaccount_id  AND eflowstatus = '2') " +
              "AND t2.`deleted_at` IS NULL AND t1.`deleted_at` IS NULL ";

    let params = {ecompany_id:obj.ecompany_id, usereaccount_id : obj.eaccount_id};
    var list = await this.dao.customQuery(sql, params);
    if(!list || list.length == 0) {
      return [];
    }
    list.forEach(item => {
      var ecompany = {};
      ecompany.id = item.companyid;
      ecompany.name = item.companyname;
      item.ecompany = ecompany;
    });
    return list;
  }
}
module.exports=EtemplateService;
