const system=require("../../system");
const ServiceBase=require("../sve.base");
class EntiitinfoService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(EntiitinfoService));
     this.cacheManager=system.getObject("db.cacheManager");
     //this.appDao=system.getObject("db.appDao");
  }
  async getUidStr(len, radix) {
      var chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'.split('');
      var uuid = [], i;
      radix = radix || chars.length;
      if (len) {
        for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random()*radix];
      } else {
        var r;
        uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
        uuid[14] = '4';
        for (i = 0; i < 36; i++) {
          if (!uuid[i]) {
            r = 0 | Math.random()*16;
            uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
          }
        }
      }
      return uuid.join('');
  }
  async getOrCreateEntIitInfo(obj){
    var openid = obj.openid;
    var statisticalCompanyName =obj.statisticalCompanyName;
    var statisticalTime=obj.statisticalTime;
    // var usertype = obj.usertype;
    var result={
       code: 1,
       message: "success",
       data: {}
    };
    if(openid==null||openid==""||openid=="undefined"){
      result.code=-101;
      result.message="openid参数有误";
      return result;
    }
    console.log(openid);
    var userInfo =await this.cacheManager["AppletUserinfoCache"].get(openid);
    console.log(userInfo);
    if(userInfo=="null"||userInfo==null||userInfo=="undefined"){
      result.code=-105;
      result.message="用户信息有误";
      return result;
    }
    userInfo=JSON.parse(userInfo);
    if(statisticalCompanyName==null||statisticalCompanyName==""||statisticalCompanyName=="undefined"){
      result.code=-102;
      result.message="statisticalCompanyName参数有误";
      return result;
    }
    if(statisticalTime==null||statisticalTime==""||statisticalTime=="undefined"){
      result.code=-103;
      result.message="statisticalTime参数有误";
      return result;
    }
    var times = statisticalTime.split("-");
    console.log(times);
    var statisticalYear=times[0];
    var statisticalMonth=times[1];
    if(!statisticalYear || !statisticalMonth){
      result.code=-104;
      result.message="statisticalTime格式转换有误";
      return result;
    }
    var whereobj={user_id:userInfo.id,statisticalYear:statisticalYear,statisticalMonth:statisticalMonth,statisticalCompanyName:statisticalCompanyName};
    console.log(whereobj);
    var entIitInfo= await this.dao.model.findOne({where:whereobj});
    console.log(entIitInfo);
    if(!entIitInfo){
      var shareOnlyCode=await this.getUidStr(9,60);
      shareOnlyCode=shareOnlyCode+statisticalYear+""+statisticalMonth;
      console.log(shareOnlyCode);
      var entIitObj={
        shareOnlyCode:shareOnlyCode,
        user_id:userInfo.id,app_id:userInfo.app_id,onlyCode:userInfo.unionId,userName:userInfo.userName,nickName:userInfo.userName,
        statisticalYear:statisticalYear,statisticalMonth:statisticalMonth,statisticalCompanyName:statisticalCompanyName,statisticalTime:statisticalTime
      }
      console.log(entIitObj);
      var entIit = await this.dao.create(entIitObj);
      console.log(entIit);
      result.data = entIit;
    }else{
      result.data = entIitInfo;
    }
    return result
  }
  
}
module.exports=EntiitinfoService;
