const system=require("../../system");
const ServiceBase=require("../sve.base");
class EcompanyService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(EcompanyService));
     this.etemplateDao = system.getObject("db.etemplateDao");
     this.wxSve = system.getObject("service.wxSve");
  }

  async importCompany(name, nameA, encryptkey, posturl, etemplate) {
    let self = this;

    if(!name) {
      return 0
    }
    var company = await super.findOne({name:name});
    if(company) {
      return 0;
    }

    company = {
      "name" : name,
      "nameA" : nameA || '智信云（天津）科技有限公司',
      "isEnabled" : true,
      "isQuiet" : true,
      "sealurl" : "",
      "encryptkey" : encryptkey || "",
      "posturl": posturl || ""
    }
    return this.db.transaction(async function (t){
        // 更新派工态
        company = await self.dao.create(company, t);

        var qrcodeurl = await self.wxSve.makeQrWithScene("wxdc08c441c9fdb7a7", company.id);

        var newTemplate = {
          ecompany_id:company.id,
          name:name,
          templateid:etemplate.templateid,
          filekey:etemplate.filekey,//e签宝返回文件key
          filepath:etemplate.filepath,//需要在后台补充
          placeholderkey:etemplate.placeholderkey,//模板占位信息
          isEnabled:true,
          qrcodeurl:qrcodeurl
        };

        await self.etemplateDao.create(newTemplate, t);
        return company.id;
    });
  }

}


module.exports=EcompanyService;
