const system=require("../../system");
const ServiceBase=require("../sve.base");
class DrafthistoryService extends ServiceBase{
    constructor() {
        super(ServiceBase.getDaoName(DrafthistoryService));
    }

    //添加增删改查方法
    async createOne(obj) {
        try{
            let result = await this.dao.model.create(obj);
            return result;
        }catch(e) {
            console.log('--drafthistory createOne error: ', e);
            return e;
        }
    }

    async deleteByObj(obj) {
        //例：obj = {'id': '2', 'userId': '333', 'draftName': '测试2'}
        try{
            let result = await this.dao.model.destroy({where: obj});
            return result;
        }catch(e) {
            console.log('--drafthistory delete error: ', e);
            return e;
        }
    }

    async updateByObj(obj, newobj) {
        //例：obj = {'id': '2', 'userId': '333', 'draftName': '测试2'}

        console.log('123456:  ', obj, newobj);
        try{
            let result = await this.dao.model.update(newobj, {where: obj});
            return result;
        }catch(e) {
            console.log('--drafthistory update error: ', e);
            return e;
        }
    }

    async findByObj(obj) {
        //查询当前用户所有草稿版本例：obj = {'userId': '333'}
        //查询当前用户的某个名字草稿版本例：obj = {'userId': '333', 'draftName': '测试2'}
        try{
            // console.log('draft service:  ',this.dao);
            let result = await this.dao.model.findAll({where: obj});
            return result;
        }catch(e) {
            console.log('--drafthistory find error:', e);
            return e;
        }
    }

    async findOneById(obj) {
        try{
            let result = await this.dao.model.findOne({where: obj});
            return result;
        }catch(e) {
            console.log('--drafthistory find error:', e);
            return e;
        }
    }
}

module.exports=DrafthistoryService;