const system=require("../../system");
const ServiceBase=require("../sve.base");
class ChannelcustomerService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(ChannelcustomerService));
     this.pAccountDao=system.getObject("db.pAccountDao");
     this.tradeDao=system.getObject("db.tradeDao");
  }
  async save(obj){
    var openid = obj.openid;
    var customerMobile=obj.customerMobile;
    var channelCode = obj.channelCode;
    var result={
       code: 1,
       message: "success",
       data: {}
    };
    if(openid==null||openid==""||openid=="undefined"){
      result.code=-101;
      result.message="openid参数有误";
      return result;
    }
    if(customerMobile==null||customerMobile==""||customerMobile=="undefined"){
      result.code=-102;
      result.message="customerMobile参数有误";
      return result;
    }
    console.log(openid);
    if(channelCode==null||channelCode==""||channelCode=="undefined"){
      result.code=-104;
      result.message="channelCode参数有误";
      return result;
    }
    var userInfo =await this.cacheManager["AppletUserinfoCache"].get(openid);
    console.log(userInfo);
    if(userInfo=="null"||userInfo==null||userInfo=="undefined"){
      result.code=-105;
      result.message="用户信息有误";
      return result;
    }
    userInfo=JSON.parse(userInfo);
    console.log(userInfo);
    var whereobj={customerMobile:customerMobile};
    var channelCustomer= await this.dao.model.findOne({where:whereobj});
    if(channelCustomer && channelCustomer.id){
      result.code=-103;
      result.message="该客户已存在，不能重复保存";
      return result;
    }else{
      var cObj={
        salesmanAppId:userInfo.app_id,
        salesmanUserId:userInfo.id,
        salesmanAccountId:userInfo.account_id,
        salesmanNickName:userInfo.nickName,
        salesmanOpenid:userInfo.openId,
        salesmanOnlyCode:userInfo.onlyCode,
        customerMobile:customerMobile,
        channelType:channelCode
      };
      var customer = await this.dao.create(cObj);
      console.log(customer);
      // result.data=d;
      return result;
    }
  }
}
module.exports=ChannelcustomerService;
// var test = new ChannelcustomerService();
// var obj={openid:"testopenid",customerMobile:"13075556693",channelCode:"yjs"};
// test.save(obj).then(function(data){
//   console.log(data);
// })
