const system = require("../../system");
const ServiceBase = require("../sve.base");
class BytmDynamicsService extends ServiceBase {
        constructor() {
                super(ServiceBase.getDaoName(BytmDynamicsService));
                this.wxSve = system.getObject("service.wxSve");
        }
        async delMonitDynamics(params, result) {
                var self = this;
                var only_code = params.onlyCode || "";
                var id_list = params.id_list || "";
                if (!id_list && id_list.length == 0) {
                        result.code = -100;
                        result.message = "id_list参数错误";
                        return result;
                }
                await this.dao.model.destroy({ where: { onlyCode: only_code, id: { [this.db.Op.in]: id_list } } });
                return { code: 1, message: "success", data: {} }
        }
        async userSumByuserId(userid) {
                var wobj = { where: { user_id: userid, isRead: 0 } };
                var asum = await this.dao.findSum("dynamicsNum", wobj);
                return asum;
        }
        async putReadByUserId(userid) {
                var wobj = { where: { user_id: userid, isRead: 0 } };
                return await this.dao.model.update({ isRead: 1 }, wobj);
        }
        async notifyWxTmDynamics() {
                var self = this;
                let sql = "select user_id from `byc_bytm_dynamics` where isRemind=0 group by user_id limit 500";
                let rs = await this.customQuery(sql, null);
                if (!rs || rs.length == 0) {
                        return "暂时没有数据，无需处理"
                }
                let list = [];
                for (let r of rs) {
                        list.push(r.user_id);
                }
                let userSql = "select id,notifyOpenId from `p_user` where id in(" + list.join(",") + ")";
                let userList = await this.customQuery(userSql, null);
                let filterUserList = userList.filter(f => f.notifyOpenId);
                if (!filterUserList || filterUserList.length == 0) {
                        return "查询的用户notifyOpenId信息全部为空，无需处理";
                }
                //修改通知用户Id列表
                var putNoticeUserIdList = [];
                //微信通知列表
                var wechatNoticeList = [];
                //处理用户有notifyOpenId信息
                for (let i = 0; i < filterUserList.length; i++) {
                        var user = filterUserList[i];
                        if (user) {
                                putNoticeUserIdList.push(user.id);
                                var tmpSql = "select `userName`,`monitName`,`dynamicsNum`,`created_at` from byc_bytm_dynamics where isRemind=0 and `user_id`=" + user.id;
                                let notifyList = await self.customQuery(tmpSql, null);
                                if (!notifyList || notifyList.length == 0) {
                                        continue;
                                }
                                for (let r of notifyList) {
                                        //微信消息模板
                                        var wechatParam = {
                                                url: "",
                                                first: "您好，您有新的商标动态",
                                                keyword1: "您的【" + r.monitName + "】监控有" + r.dynamicsNum + "条新动态，请到电脑端登录标眼查(https://search.gongsibao.com)进行查看！",
                                                keyword2: "待查看",
                                                openid: user.notifyOpenId
                                        }
                                        wechatNoticeList.push(wechatParam);
                                }
                        }
                }
                if (wechatNoticeList.length > 0) {
                        var putSql = "UPDATE `byc_bytm_dynamics` SET isRemind=1 WHERE isRemind=0 and user_id IN(" + putNoticeUserIdList.join(",") + ")"
                        await self.customExecAddOrPutSql(putSql, null);
                        //微信处理
                        var data = null;
                        for (var i = 0; i < wechatNoticeList.length; i++) {
                                var wechatItem = wechatNoticeList[i];
                                data = {
                                        first: wechatItem.first,
                                        keyword1: { value: wechatItem.keyword1 },
                                        keyword2: { value: wechatItem.keyword2 }
                                }
                                self.wxSve.sendTmplMsg(wechatItem.openid, "VeqWpbYKzdVvtcJoa5JGcWWK_Hl7qoHCxk25KhIxklo", wechatItem.url, data, null);
                        }
                }
                return "成功处理" + wechatNoticeList.length + "条数据";

        }
}
module.exports = BytmDynamicsService;
