const system=require("../../system");
const ServiceBase=require("../sve.base");
class AccountService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(AccountService));
     this.pAccountDao=system.getObject("db.pAccountDao");
     this.tradeDao=system.getObject("db.tradeDao");
     //this.appDao=system.getObject("db.appDao");
  }
  async getPAccountBalance(accountid,appid){

    return this.cacheManager["AccountBalanceCache"].get(accountid,appid);
  }
  async getAccountBalance(accountid,appid){
    return this.cacheManager["AccountBalanceCache"].get(accountid,appid);
  }
  async delAccountBalance(accountid,appid){
    return this.cacheManager["AccountBalanceCache"].del(accountid,appid);
  }
  async getFindById(reqParam,aid){
    if(reqParam!="p"){
      return super.findById(aid);
    }else {
      return this.pAccountDao.findById(1);
    }
  }

  async getpetradesSum(){
    var publicExpenseSum = await this.tradeDao.findSum("renAmount",{where:{[this.dao.db.Op.or]: [{tradeType: 'publicExpense'}, {tradeType: 'subPublicExpense'}]}});
    return publicExpenseSum;
  }
  async subPublicExpense(obj,req){
    var self = this;
    var publicExpenseSum = await this.tradeDao.findSum("renAmount",{where:{[this.dao.db.Op.or]: [{tradeType: 'publicExpense'}, {tradeType: 'subPublicExpense'}]}});
    return this.db.transaction(async function (t){
            if( obj.account == publicExpenseSum ){
              var reqParams={
                  account_id : req.session.user.account_id,
                  user_id : req.session.user.id,
                  username : req.session.user.nickName,
                  renAmount : 0-publicExpenseSum,
                  tradeType : "subPublicExpense",
                  status : "settled",
                  tradeDate:new Date(),
              }
              var result = await self.tradeDao.model.create(reqParams,t);
              return {status:1,msgs:obj.account+"元官费操作成功",data:result};
            }
            else{
              return {status:-1,msgs:"机器人正在提报，请稍等",data:null};
            }

          });
  }

  async getReferrerRankList(topNum){
    var result={
       code: 1,
       message: "success",
       data: []
    };
    if(topNum==null||topNum==""||topNum=="undefined"){
      topNum=10;
    }
    if(topNum>100){
      topNum=100;
    }
    var sql="SELECT userName,nickName,onlyCode,pvCount,headUrl FROM p_account AS a RIGHT JOIN"+
            " (SELECT referrerOnlyCode AS onlyCode,COUNT(1) AS pvCount FROM p_account WHERE referrerOnlyCode!='' AND "+
            " referrerOnlyCode IS NOT NULL GROUP BY referrerOnlyCode ORDER BY pvCount DESC LIMIT 0,:tmpTopNum) AS b"+
            " ON a.`unionId`=b.onlyCode ORDER BY pvCount DESC";
    var paras={tmpTopNum:topNum};
    var list= await this.dao.customQuery(sql,paras);
    if(list==null&&list.length==0){
      result.message="暂无排名数据";
      return result;
    }
    var self=this;
    for (var i = 0; i < list.length; i++) {
      var item=list[i];
      if(item!=null){
        //返回的服务项目列表
        var rank_item={
               rank:{
                  nick_name:item.nickName,
                  head_url:item.headUrl,
                  pv_count:item.pvCount
             }
        };
        result.data.push(rank_item);
      }
    }
    return result;
  }
}
module.exports=AccountService;
