const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("workcrsubmit", {
    orderCreateOnlyCode: DataTypes.STRING(50),//订单创建者OnlyCode
    orderCreateAppId: DataTypes.INTEGER,//订单创建者平台应用id
    orderNum: DataTypes.STRING(50),//订单号
    sourceTypeName: DataTypes.STRING(50),//订单来源类型名称
    sourceType: {//订单来源类型，1PC，2移动商城，4渠道方，默认为2
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.source_type),
      set: function (val) {
        this.setDataValue("sourceType", val);
        this.setDataValue("sourceTypeName", uiconfig.config.pdict.source_type[val]);
      }
    },
    sourceNotes: DataTypes.STRING,//订单来源备注
    channelCode: DataTypes.STRING,//渠道编码
    channelName: DataTypes.STRING,//渠道名称
    relevanceStatus: {//状态，1未关联订单，2，已关联订单
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.copyright_status),
      set: function (val) {
        this.setDataValue("relevanceStatus", val);
        this.setDataValue("relevanceStatusName", uiconfig.config.pdict.copyright_status[val]);
      }
    },
    relevanceStatusName: DataTypes.STRING,//状态名称
    statusProgress: {
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.statusProgress_status),
      set: function (val) {
        this.setDataValue("statusProgress", val);
        this.setDataValue("statusProgressName", uiconfig.config.pdict.statusProgress_status[val]);
      },
    },
    statusProgressName: DataTypes.STRING,//进展状态名称
    orderNotes: DataTypes.STRING,//订单备注
    opAppId: DataTypes.INTEGER,//操作者平台应用id
    opUserId: DataTypes.INTEGER,//操作用户id
    opUserName: DataTypes.STRING,//操作平台用户名
    opOnlyCode: DataTypes.STRING,//操作者唯一码
    opNotes: DataTypes.STRING,//操作备注
    name: DataTypes.STRING,//作品名称
    compositionType: {//作品著作权分类（wz文字、ks口述、yl音乐、xj戏剧、qy曲艺 、wd舞蹈 、zjys杂技艺术、ms美术 、jz建筑 、sy摄影 、dy电影和类似摄制电影方法创作的作品、tx图形、mj模型、qt其他 ）
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.composition_type),
      set: function (val) {
        this.setDataValue("compositionType", val);
        this.setDataValue("compositionTypeName", uiconfig.config.pdict.composition_type[val]);
      },
    },
    compositionTypeName: DataTypes.STRING(50),//作品著作权分类名称
    compositionTypeDesc: DataTypes.STRING(500),//作品著作权分类说明
    authorData: DataTypes.STRING(4000),//作者姓名或名称以及作品署名：[{"authorName":"作者","authorSign":"作者署名"}]
    opusInditeKind: {//作品创作性质：yc:原创,gb:改编,fy:翻译,hb:汇编,zs:注释,zl:整理,qt:其他
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.opus_indite_kind),
      set: function (val) {
        this.setDataValue("opusInditeKind", val);
        this.setDataValue("opusInditeKindName", uiconfig.config.pdict.opus_indite_kind[val]);
      },
    },
    opusInditeKindName: DataTypes.STRING(50),//作品创作性质名称
    opusDesc: DataTypes.STRING(500),//作品创作性质说明
    opusCreateDate: DataTypes.DATE,//作品创作完成日期
    finishCountry: DataTypes.STRING(50),//完成国家
    finishCity: DataTypes.STRING(50),//完成城市
    publishStatus: {//发表状态1已发表，2未发表
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.publish_status),
      set: function (val) {
        this.setDataValue("publishStatus", val);
        this.setDataValue("publishStatusName", uiconfig.config.pdict.publish_status[val]);
      },
    },
    publishStatusName: DataTypes.STRING(50),//发表状态名称
    appearDate: DataTypes.DATE,//首次发表日期
    appearCountry: DataTypes.STRING(50),//首次发表地点国家
    appearCity: DataTypes.STRING(50),//首次发表地点城市
    obtainMode: {//权利取得方式：ys:原始,jc:继承,cs:承受,qt:其他
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.obtain_mode),
      set: function (val) {
        this.setDataValue("obtainMode", val);
        this.setDataValue("obtainModeName", uiconfig.config.pdict.obtain_mode[val]);
      },
    },
    obtainModeName: DataTypes.STRING(50),//权利取得方式名称
    inheritDesc: DataTypes.STRING(500),//权利取得方式为原始以外的有此值：权利取得方式说明
    rightOwnMode: {//权利归属方式：grzp:个人作品,hzzp:合作作品,frzp:法人作品,zwzp:职务作品,wtzp:委托作品
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.right_own_mode),
      set: function (val) {
        this.setDataValue("rightOwnMode", val);
        this.setDataValue("rightOwnModeName", uiconfig.config.pdict.right_own_mode[val]);
      },
    },
    rightOwnModeName: DataTypes.STRING(50),//权利归属方式名称
    rightOwnDesc: DataTypes.STRING(500),//权利归属方式说明
    rightScope: {//权利拥有状况1全部，2部分
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.range_type),
      set: function (val) {
        this.setDataValue("rightScope", val);
        this.setDataValue("rightScopeName", uiconfig.config.pdict.range_type[val]);
      },
    },
    rightScopeName: DataTypes.STRING(50),//权利拥有状况名称
    rightScopeList: DataTypes.STRING(500),//权利拥有状况为部分有此值，部分选项集合
    ownPartDesc: DataTypes.STRING(50),//权利拥有状况说明
    emedium: DataTypes.STRING(50),//电子介质
    ecount: DataTypes.STRING(50),//电子介质几件
    pmedium: DataTypes.STRING(50),//纸介质
    pcount: DataTypes.STRING(50),//纸介质几张
    applyType: {//申请办理方式1由著作权任申请，2由代理任申请
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.apply_type),
      set: function (val) {
        this.setDataValue("applyType", val);
        this.setDataValue("applyTypeName", uiconfig.config.pdict.apply_type[val]);
      },
    },
    applyTypeName: DataTypes.STRING(50),//申请办理方式名称
    proxyCode: DataTypes.STRING,//代理号
    subNotes: DataTypes.TEXT,//提报返回备注
    declarationUrl:DataTypes.STRING(500),//法人作品声明Url
    authorizationUrl:DataTypes.STRING(500),//作品授权书Url
    descUrl:DataTypes.STRING(500),//作品说明Url
    sampleUrl:DataTypes.STRING(500),//作品样本Url
    workPicUrl:DataTypes.STRING(500),//作品Url
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'h_works_submit',
      validate: {
      }
    });
}
