const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("user", {
    nickName: {
      type:DataTypes.STRING,
      allowNull: true,
    },
    openId:DataTypes.STRING,
    headUrl: DataTypes.STRING,
    // from: DataTypes.STRING,
    unionId:DataTypes.STRING,
    account_id:DataTypes.INTEGER,
    app_id:DataTypes.INTEGER,
    isAdmin:{
      type:DataTypes.BOOLEAN,
      defaultValue: false
    },
    isEnabled:{
      type:DataTypes.BOOLEAN,
      defaultValue: true
    },
    sex: {
      type:DataTypes.ENUM,
      allowNull: true,
      values: Object.keys(uiconfig.config.pdict.sex),
    },
    source:DataTypes.STRING,
    userName:DataTypes.STRING,
    onlyCode:DataTypes.STRING,
    referrerOnlyCode:DataTypes.STRING,
    mobile:DataTypes.STRING,
    isShop:DataTypes.INTEGER,
    shopNum:DataTypes.BIGINT,
    email:DataTypes.STRING(50),
    concernShopOnlyCode:DataTypes.STRING,//关注店铺的唯一码
    personsSign:DataTypes.STRING,//个人签名
    lifePhoto:DataTypes.STRING,//生活照
    photoShow:DataTypes.STRING,//图片介绍
    wxNum:DataTypes.STRING,//微信号
    telNum:DataTypes.STRING(20),//座机号
    customerNum:DataTypes.BIGINT,//客户号（boss小程序有此值，boss的当前公司信息号）*
    companyName:DataTypes.STRING,//用户公司名称
    userPost:DataTypes.STRING,//用户岗位
    companyAddr:DataTypes.STRING,//公司地址
    customerrollpic_id:DataTypes.INTEGER,//关注的海报的id*
    serviceCustomerCount:DataTypes.INTEGER,//用户服务过的客户数量,
    tm_company_id : DataTypes.INTEGER,      // 商标搜索公司id
    tm_copmpany_name : DataTypes.STRING(50), // 商标搜索公司名称
    companyOnlyCode:DataTypes.STRING(50),//公司的唯一码,
    notifyOpenId:DataTypes.STRING,   // 公众号通知微新id
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'p_user',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
