const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("trademark", {
    orderNum: DataTypes.STRING,
    tmTypeName: DataTypes.STRING,
    tmType: {
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_type),
      set: function (val) {
        this.setDataValue("tmType", val);
        this.setDataValue("tmTypeName", uiconfig.config.pdict.tm_type[val]);
      }
    },
    tmFormTypeName: DataTypes.STRING,
    tmFormType: {//商标类型形式：1立体、2声音、3文字、4图形、5文字及图形、6颜色组合、7彩色
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_form_type),
      set: function (val) {
        this.setDataValue("tmFormType", val);
        this.setDataValue("tmFormTypeName", uiconfig.config.pdict.tm_form_type[val]);
      }
    },
    caseTypeName: {
      type: DataTypes.STRING,
      default: "商标注册"
    },
    caseType: {
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.caseType),
      defaultValue: "sbzc",
      set: function (val) {
        this.setDataValue("caseType", val);
        this.setDataValue("caseTypeName", uiconfig.config.pdict.caseType[val]);
      }
    },
    nclOneCodes: DataTypes.STRING,
    nclSmallCodes: DataTypes.TEXT,
    tmName: DataTypes.STRING(1000),
    picUrl: DataTypes.STRING(500),
    tmNamePy: DataTypes.STRING(2000),
    tmNameEn: DataTypes.STRING(1000),
    tmNamePyjc: DataTypes.STRING(500),
    known: DataTypes.BOOLEAN,
    tmValue: DataTypes.DECIMAL(12, 2),
    coOwner: DataTypes.STRING,
    //returnReceiptUrl:DataTypes.STRING,
    submitTime: DataTypes.DATE,
    payTime: DataTypes.DATE,
    proxyCode: DataTypes.STRING,
    tmRegistNum: DataTypes.STRING,
    creatAuthorizeStuff: DataTypes.STRING(500),
    sealAuthorizeStuff: DataTypes.STRING(500),
    nclCalc_id: DataTypes.INTEGER,
    serviceItems_id: DataTypes.INTEGER,
    voiceUrl: DataTypes.STRING,
    //applier:DataTypes.STRING,
    tmStatusName: DataTypes.STRING,
    tmStatus: {
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_submit_status),
      set: function (val) {
        this.setDataValue("tmStatus", val);
        this.setDataValue("tmStatusName", uiconfig.config.pdict.tm_submit_status[val]);
      }
    },
    app_id: DataTypes.INTEGER,
    user_id: DataTypes.INTEGER,
    colorizedPicUrl: DataTypes.STRING,//彩色商标图样，类型为7则有此值
    descUrl: DataTypes.STRING,
    partnerMobile: DataTypes.STRING,
    onlyCode: DataTypes.STRING,
    userName: DataTypes.STRING,
    applyName: DataTypes.STRING,
    tbKey: DataTypes.STRING,
    tbErrorCount: DataTypes.INTEGER,
    parentProxyCode: DataTypes.STRING,//上级代理号
    parentTmRegistNum: DataTypes.STRING,//上级商标号
    newProxyCode: DataTypes.STRING,//针对废弃，新产生的代理号
    newTmRegistNum: DataTypes.STRING,//针对废弃，新产生的商标号
    remarkInfo: DataTypes.STRING,//备注信息
    opRemarkInfo: DataTypes.STRING(4000),//操作备注信息
    param1: DataTypes.STRING,//备用字段
    channelOrderNum: DataTypes.STRING(50),//渠道订单号
    channelUserId: DataTypes.STRING(50),//渠道用户ID
    app_code: DataTypes.STRING,//应用code
    tmSourceTypeName: {
      type: DataTypes.STRING(50),
      default: "PC"
    },
    tmSourceType: {//来源：1:"PC",2:"移动端",4:"渠道",8:"beehive",16:"gsb",32:"阿里云"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tmSourceType),
      defaultValue: "1",
      set: function (val) {
        this.setDataValue("tmSourceType", val);
        this.setDataValue("tmSourceTypeName", uiconfig.config.pdict.tmSourceType[val]);
      }
    },
    mobile: DataTypes.STRING,
    channelPayStatusName: {
      type: DataTypes.STRING(50),
      default: "已支付"
    },
    channelPayStatus: {//渠道支付状态，yzf已支付，wzf未支付
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.channel_pay_status),
      defaultValue: "yzf",
      set: function (val) {
        this.setDataValue("channelPayStatus", val);
        this.setDataValue("channelPayStatusName", uiconfig.config.pdict.channel_pay_status[val]);
      }
    },
    needId: DataTypes.STRING(50),//需求ID
    businessId: DataTypes.STRING(50),//业务ID
    channelOrderListInfo: DataTypes.STRING(500),//渠道服务单号对应的订单列表信息
    channelPric: DataTypes.DECIMAL(12, 2),//渠道商标单个大类的价格
    nclCount: DataTypes.INTEGER,
    nclPublicExpense: DataTypes.DECIMAL(12, 2),
    principal: DataTypes.STRING(100),//提报主体
    isPushed: DataTypes.INTEGER,//是否推送（0：未推送，1：已推送）
    lastUp: DataTypes.DATE,//最后一次回执更新的时间
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'h_trade_mark',
      validate: {

      },
      indexes: [
      ]
    });
}
