const Sequelize = require('sequelize');
const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  var Trade=db.define("trade", {
    idkey:DataTypes.STRING,
    app_id:DataTypes.INTEGER,
    account_id:DataTypes.INTEGER,
    user_id:DataTypes.INTEGER,
    username: {
      type:DataTypes.STRING,
      allowNull: true,
    },
    nickName: {
      type:DataTypes.STRING,
      allowNull: true,
    },
    serviceItemsId: {
      type:DataTypes.INTEGER,
      allowNull: true,
    },
    baoAmount:{
      type:DataTypes.DECIMAL(12,2),
      defaultValue:0.00,
    },
    renAmount:{
      type:DataTypes.DECIMAL(12,2),
      defaultValue:0.00,
    },
    desc: {
      type:DataTypes.STRING,
      allowNull: false,
    },
    remark: {
      type:DataTypes.STRING(4000),
      allowNull: true,
    },
    tradeDate: {
      type:DataTypes.DATE,
      allowNull: false,
    },
    tradeType: {
      type:DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(uiconfig.config.pdict.tradeType),
      set:function(val){
        this.setDataValue("desc",uiconfig.config.pdict.tradeType[val]);
        this.setDataValue("tradeType",val);
      }
    },
    status:{
      type:DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(uiconfig.config.pdict.tradeStatus)
    },
    orderNum: {
      type:DataTypes.STRING,
      allowNull: true,
    },
    price:{
      type:DataTypes.INTEGER,
      defaultValue:0.00,
    },
    bankTradeNum:DataTypes.STRING,//银行交易号
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     tableName: 'p_trade',
     validate: {

     },
  });
  return Trade;
}
