const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("tmflow", {
     opAppId:DataTypes.INTEGER,
     opUserId:DataTypes.INTEGER,
     opUserName:DataTypes.STRING,
     tmRegistNum:DataTypes.STRING,
     tmStatusName:DataTypes.STRING,
     tmStatus:{
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.tm_submit_status),
       set:function(val){
         this.setDataValue("tmStatus",val);
         this.setDataValue("tmStatusName",uiconfig.config.pdict.tm_submit_status[val]);
       }
     },
     opTypeName:DataTypes.STRING,
     opType:{
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.opType),
       defaultValue: "person",
       set:function(val){
         this.setDataValue("opType",val);
         this.setDataValue("opTypeName",uiconfig.config.pdict.opType[val]);
       }
     },
     caseTypeName:{
       type:DataTypes.STRING,
       default:"商标注册"
     },
     caseType:{
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.caseType),
       defaultValue: "sbzc",
       set:function(val){
         this.setDataValue("caseType",val);
         this.setDataValue("caseTypeName",uiconfig.config.pdict.caseType[val]);
       }
     },
     returnReceiptUrl:DataTypes.STRING,
     uploadFileName:DataTypes.STRING,
     opDesc:DataTypes.STRING,
     proxyCode:DataTypes.STRING,
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'h_tm_flow',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
