const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);

module.exports = (db, DataTypes) => {
  return db.define("tmcompany", {
    name: DataTypes.STRING(50),
    ownerId : DataTypes.INTEGER,    // 创建人id
    account : DataTypes.STRING(50),   // 用户名
    passwd :  DataTypes.STRING(50),   // 密码
    contact : DataTypes.STRING(30),   // 联系方式
    useCount : DataTypes.INTEGER,     // 允许使用人数
    payVoucher : DataTypes.STRING(300), // 支付凭证
    auditStatus : {
      // 审核状态: "0":"待审核","1":"审核通过","2":"审核驳回","3" :"已过期"
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tmCompanyAuditStatus),
      set:function(val) {
        this.setDataValue("auditStatus", val);
        this.setDataValue("auditStatusName",uiconfig.config.pdict.tmCompanyAuditStatus[val]);
      }
    },
    auditStatusName:DataTypes.STRING(50),
    audit_reason:DataTypes.STRING(300), // 审核备注
    audit_at:DataTypes.DATE,            // 审核时间
    valid_at:DataTypes.DATE,            // 有效期截至时间
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     tableName: 'p_tm_company',
     validate: {
     },
  });
}
