const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("tmapplierinfo", {
      orderNum:DataTypes.STRING,
      typeName:DataTypes.STRING,
      type:{
        type:DataTypes.ENUM,
        values: Object.keys(uiconfig.config.pdict.tm_apply_type),
        set:function(val){
          this.setDataValue("type",val);
          this.setDataValue("typeName",uiconfig.config.pdict.tm_apply_type[val]);
        }
      },
      applyName:DataTypes.STRING(1000),
      identityCard:DataTypes.STRING,
      applyArea:DataTypes.STRING,
      applyAddr:DataTypes.STRING,
      creditCode :DataTypes.STRING,
      businessScope:DataTypes.STRING(2000),
      applyProvince:DataTypes.STRING,
      applyCity:DataTypes.STRING,
      identityCardPic:DataTypes.STRING,
      businessLicensePic:DataTypes.STRING,
      identityCardPic2:DataTypes.STRING,
      businessLicensePic2:DataTypes.STRING,
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'h_tmapplier_info',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
