const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("statisticalrate", {
    createTime:DataTypes.STRING(10),
    totalTypeName:DataTypes.STRING,
    totalType:{
      //统计类型：enum('zxbxl'咨询变现率,'kdl'开店率,'yhfll'用户分裂率,'yhdpfxl'用户店铺分享率)
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.totalType),
      set:function(val){
        this.setDataValue("totalType",val);
        this.setDataValue("totalTypeName",uiconfig.config.pdict.totalType[val]);
      }
    },
    totalMolecule:DataTypes.DECIMAL(12,2),//统计分子（当天）
    totalDenominator:DataTypes.DECIMAL(12,2),//统计分母（当天）
    addUpMolecule:DataTypes.DECIMAL(12,2),//累计分子（包含以前所有数据）
    addUpDenominator:DataTypes.DECIMAL(12,2),//累计分母（包含以前所有数据）
    totalValue:DataTypes.DECIMAL(12,2),//统计值（当天）
    addUpValue:DataTypes.DECIMAL(12,2),//累计值
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'h_statistical_rate',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
