const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("sproduct", {
    productCata: {
      type:DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(uiconfig.config.pdict.productCata),
      defaultValue: "common",
      set:function(val){
        this.setDataValue("productCataName",uiconfig.config.pdict.productCata[val]);
        this.setDataValue("productCata",val);
      }
    },
    productCataName:{
      type:DataTypes.STRING,
      allowNull: false,
    },
    code:DataTypes.STRING,
    name:DataTypes.STRING,
    pro_service_charge:DataTypes.DECIMAL(12,2),
    pro_public_expense:DataTypes.DECIMAL(12,2),
    pro_platform_cost:DataTypes.DECIMAL(12,2),
    short_desc:DataTypes.STRING(500),
    isPubed:DataTypes.BOOLEAN,
    web_pic:DataTypes.STRING(500),
    mobile_pic:DataTypes.STRING(500),
    product_unit:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.product_unit),
      defaultValue: "0",
      set:function(val){
        this.setDataValue("product_unit",val);
      }
    },
    product_params:DataTypes.STRING(500),
    product_desc_pic:DataTypes.STRING(500),
    descr:DataTypes.STRING,
    operator_info:DataTypes.STRING,

  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'h_service_items',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
