const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("softwarecrsubmit", {
    orderCreateOnlyCode: DataTypes.STRING,//订单创建者OnlyCode
    orderCreateAppId: DataTypes.INTEGER,//订单创建者平台应用id
    orderNum: DataTypes.STRING,//订单号
    sourceTypeName: DataTypes.STRING,//订单来源类型名称
    sourceType: {//订单来源类型，1PC，2移动商城，4渠道方，默认为2
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.source_type),
      set: function (val) {
        this.setDataValue("sourceType", val);
        this.setDataValue("sourceTypeName", uiconfig.config.pdict.source_type[val]);
      }
    },
    sourceNotes: DataTypes.STRING,//订单来源备注
    channelCode: DataTypes.STRING,//渠道编码
    channelName: DataTypes.STRING,//渠道名称
    relevanceStatus: {//关联状态，1未关联订单，2，已关联订单
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.copyright_status),
      set: function (val) {
        this.setDataValue("relevanceStatus", val);
        this.setDataValue("relevanceStatusName", uiconfig.config.pdict.copyright_status[val]);
      }
    },
    relevanceStatusName: DataTypes.STRING,//关联状态名称
    statusProgress: {
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.statusProgress_status),
      set: function (val) {
        this.setDataValue("statusProgress", val);
        this.setDataValue("statusProgressName", uiconfig.config.pdict.statusProgress_status[val]);
      },
    },
    statusProgressName: DataTypes.STRING,
    orderNotes: DataTypes.STRING,//订单备注
    opAppId: DataTypes.INTEGER,//操作者平台应用id
    opUserId: DataTypes.INTEGER,//操作用户id
    opUserName: DataTypes.STRING,//操作平台用户名
    opOnlyCode: DataTypes.STRING,//操作者唯一码
    opNotes: DataTypes.STRING,//操作备注
    softwareName: DataTypes.STRING,//软件名称
    softwareShortName: DataTypes.STRING,//软件简介名称
    typeNum: DataTypes.STRING,//分类号
    descTypeName: DataTypes.STRING,//说明类型名称
    descType: {//说明类型1原创，2修改（含翻译软件、合成软件）
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.desc_type),
      set: function (val) {
        this.setDataValue("descType", val);
        this.setDataValue("descTypeName", uiconfig.config.pdict.desc_type[val]);
      },
    },
    putDescType: DataTypes.STRING,//软件作品说明是修改有此值：{is_put:0-是修改,is_original:1-原有软件已经登记,original_num:"xxxxxxxx"-原登记号50,put_desc:""-修改合成或翻译说明400}
    devDate: DataTypes.DATE,//开发日期
    isPublish: DataTypes.INTEGER,//发表状态0未发表，1已发表
    publishedDate: DataTypes.DATE,//发表状态是已发表有此值：首次发表日期
    publishedCountryName: DataTypes.STRING,//发表状态是已发表有此值：首次发表国家
    publishedCityName: DataTypes.STRING,//发表状态是已发表有此值：首次发表城市
    devWayName: DataTypes.STRING,//开发方式名称
    devWay: {//开发方式1独立开发，2合作开发，3委托开发，4下达任务开发
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.dev_way),
      set: function (val) {
        this.setDataValue("devWay", val);
        this.setDataValue("devWayName", uiconfig.config.pdict.dev_way[val]);
      },
    },
    getWayName: DataTypes.STRING,//权利获得方式名称
    getWay: {//权利获得方式1原始取得，2继受取得
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.get_way),
      set: function (val) {
        this.setDataValue("getWay", val);
        this.setDataValue("getWayName", uiconfig.config.pdict.get_way[val]);
      },
    },
    inheritGetWayInfo: DataTypes.STRING,//权利获得方式为继受有此值：继受取得方式信息（{"inheritanceMode":"继承","isSoftReg":"软件是否已登记","regNumber":"原登记号","isSoftChanged":"变更","changeNumber":"变更或补充证明编号"}）
    rangeTypeName: DataTypes.STRING,//权利范围名称
    rangeType: {//权利范围1全部，2部分
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.range_type),
      set: function (val) {
        this.setDataValue("rangeType", val);
        this.setDataValue("rangeTypeName", uiconfig.config.pdict.range_type[val]);
      },
    },
    rangeTypePartInfo: DataTypes.STRING,//权利范围为部分有此值：权利范围部分信息（数组存储）
    hardwareInfo: DataTypes.STRING,//硬件环境
    softwareInfo: DataTypes.STRING,//软件环境
    programmingLanguage: DataTypes.STRING,//编程语言
    sourceCodeCapacity: DataTypes.STRING,//源程序量
    softFunctionAndSpecialty: DataTypes.STRING,//主要功能和技术特点
    applyTypeName: DataTypes.STRING,//申请办理方式名称
    applyType: {//申请办理方式1由著作权任申请，2由代理任申请
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.apply_type),
      set: function (val) {
        this.setDataValue("applyType", val);
        this.setDataValue("applyTypeName", uiconfig.config.pdict.apply_type[val]);
      },
    },
    depositTypeName: DataTypes.STRING,//交存类型名称
    depositType: {//交存类型1一般交存，2例外交存
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.deposit_type),
      set: function (val) {
        this.setDataValue("depositType", val);
        this.setDataValue("depositTypeName", uiconfig.config.pdict.deposit_type[val]);
      },
    },
    proxyCode: DataTypes.STRING,//代理号
    isMutilDoc: DataTypes.STRING,//一种文档或多种文档
    mutilDocType: DataTypes.STRING,//多种文档，种类为12
    difmatReferModeExcep: DataTypes.STRING,//使用黑色宽斜线覆盖或前10页XXXX
    difmatReferPages: DataTypes.STRING,//使用黑色宽斜线覆盖，页码为XXX
    softwareVersion: DataTypes.STRING(50),//软件版本
    fileUrl: DataTypes.STRING,//文件链接
    zipFileUrl: DataTypes.STRING,//压缩文件链接
    subNotes: DataTypes.TEXT,//提报返回备注
    descUrl: DataTypes.TEXT,//说明书Url
    codeUrl: DataTypes.TEXT,//代码url
    enDescUrl: DataTypes.TEXT,//英文解释说明url
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'h_software_submit',
      validate: {
      }
    });
}
