const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("shopserviceitem", {
    // shop_id:DataTypes.INTEGER,//connection.js已经在关系中建立
    // servicesitem_id:DataTypes.INTEGER,//connection.js已经在关系中建立
    servicesitem_code:DataTypes.STRING(50),
    app_id:DataTypes.INTEGER,
    user_id:DataTypes.INTEGER,
    userName:DataTypes.STRING,
    onlyCode:DataTypes.STRING,
    pushMoney: DataTypes.DECIMAL(12,2),
    customTotalAmount: DataTypes.DECIMAL(12,2),
    profitRatioTypeName: DataTypes.STRING,
    profitRatioType:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.profitRatioType),
      set:function(val){
        this.setDataValue("profitRatioType",val);
        this.setDataValue("profitRatioTypeName",uiconfig.config.pdict.profitRatioType[val]);
      }
    },
    customHotline:DataTypes.STRING(20),
    customNotes: DataTypes.STRING,
    shopNum:DataTypes.BIGINT,
    itemType:{
      type:DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(uiconfig.config.pdict.productCata),
      defaultValue: "ip",
    },
    channelCode:{
      //渠道编码：p_channel表中的channelCode
      type:DataTypes.STRING(20),
      defaultValue:"hhr",
    },
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'h_shop_service_item',
     validate: {
     }
  });
}
