const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("servicetype", {
    // channel_id配置关系引用
    code:{//类别码
      type:DataTypes.STRING(50),
      allowNull:false,
      unique: true
    },
    name:{//类别名称
      type:DataTypes.STRING,
      allowNull:false,
    },
    level:{
      type:DataTypes.INTEGER,
      defaultValue:1,
    },
    pid:{
      type:DataTypes.INTEGER,
      defaultValue:0,
    },
    notes: DataTypes.STRING,
    isEnabled:{
      type:DataTypes.INTEGER,
      defaultValue:1,
    },
    channelCode:DataTypes.STRING(20),//渠道编码：p_channel表中的channelCode
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'p_service_type',
     validate: {

     },
     indexes:[

     ]
  });
}
