const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("servicesitem", {
    itemTypeName:{//服务类型名称
      type:DataTypes.STRING,
      defaultValue:"商标",
    },
    itemType:{
      //项目类型:ip:商标,ic:版权,pa:专利,iso:海外业务,common:增值服务,icbc:工商注册,zscq:知识产权,cwfw:财务服务,hyzz:行业资质,gqzr:股权转让,xzsp:行政审批
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.productCata),
      set:function(val){
        this.setDataValue("itemType",val);
        this.setDataValue("itemTypeName",uiconfig.config.pdict.productCata[val]);
      },
      defaultValue:"ip",
    },
    code:{//项目操作码
      type:DataTypes.STRING(50),
      allowNull:false,
      unique: true
    },
    name:{//项目名称
      type:DataTypes.STRING,
      allowNull:false,
    },
    serviceCharge:{//服务费
      type:DataTypes.DOUBLE,
      allowNull:true,
    },
    publicExpense:{//官费
      type:DataTypes.DOUBLE,
      allowNull:true,
    },
    platformCost:{//平台使用费
      type:DataTypes.DOUBLE,
      allowNull:true,
    },
    platformWorkFloorPrice:DataTypes.INTEGER,//委托平台服务的底价---计算出--不可修改  ok
    selfWorkFloorPrice:DataTypes.INTEGER,//自助作业的底价---计算出--不可修改         ok
    guidePrice:DataTypes.INTEGER,//指导价格----后台手填，验证超过底价                  ok
    shortDesc:{//项目简介
      type:DataTypes.STRING(4000),
      allowNull:true,
    },
    isPubed:{//是否可以交易，0不发布，1发布，默认为1
      type:DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: true,
    },
    webPic:{//web端图片
      type:DataTypes.STRING,
      allowNull: true,
    },
    mobilePic:DataTypes.STRING, //移动端图片
    unit:{
      // 项目单位，如：0人民币，1美元
      type:DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(uiconfig.config.pdict.product_unit),
      defaultValue: "0",
    },
    params:{//项目参数
      type:DataTypes.STRING,
      allowNull: true,
    },
    descr:{//描述
      type: DataTypes.TEXT('long'),
      allowNull: true,
    },
    opOnlyCode:{//操作人唯一编码
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    hotline:DataTypes.STRING(50),//热线咨询电话                                           ok
    notes:DataTypes.STRING,//备注
    platformProfitRatio:DataTypes.INTEGER,//平台分润比例
    mobileContentImg:DataTypes.STRING,//产品内容图片                                    ok
    answerConent:DataTypes.TEXT,//常见问题                                             ok
    nclOneCodesNum:{//产品包含系列件数
      type:DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 1,
    },
    sort:{  //排序
      type:DataTypes.DOUBLE,
      allowNull: true,
      defaultValue: 1,
    },
    isRecommendName:{
      // 是否推荐名称
      type:DataTypes.STRING,
      defaultValue:"否",
    },
    isRecommend:{
      //是否推荐："0": "否", "1": "是"
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.isRecommend),
      set:function(val){
        this.setDataValue("isRecommend",val);
        this.setDataValue("isRecommendName",uiconfig.config.pdict.isRecommend[val]);
      },
      defaultValue:"0",
    },
    isNegotiableName:{
      //是否面议名称
      type:DataTypes.STRING,
      defaultValue:"否",
    },
    isNegotiable:{
      //是否面议："0": "否", "1": "是"
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.isRecommend),
      set:function(val){
        this.setDataValue("isNegotiable",val);
        this.setDataValue("isNegotiableName",uiconfig.config.pdict.isRecommend[val]);
      },
      defaultValue:"0",
    },
    servicesReducedRate:{
      //服务项的折扣率
      type:DataTypes.DECIMAL(12,2),
      defaultValue:1,
    },
    channelCode:{
      //渠道编码：p_channel表中的channelCode
      type:DataTypes.STRING(20),
      defaultValue:"hhr",
    },
    isSeckillName:{
      // 是否秒杀名称
      type:DataTypes.STRING,
      defaultValue:"否",
    },
    isSeckill:{
      //是否秒杀："0": "否", "1": "是"
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.isRecommend),
      set:function(val){
        this.setDataValue("isSeckill",val);
        this.setDataValue("isSeckillName",uiconfig.config.pdict.isRecommend[val]);
      },
      defaultValue:"0",
    },
    seckillEndTime:DataTypes.DATE,//秒杀结束时间
    nclOneCodes:DataTypes.STRING(20),//商标尼斯大类
    authorName:DataTypes.STRING(20),//商标发布者名称
    authorMobile:DataTypes.STRING(20),//商标发布者手机号
    priceRangeMin:DataTypes.DOUBLE,//商标价格区间最小值
    priceRangeMax:DataTypes.DOUBLE,//商标价格区间最大值
    tmExpirationDate:DataTypes.DATE,//商标到期时间
    applyName:DataTypes.STRING(500),//商标申请人
    authorOnlyCode:DataTypes.STRING(50),//商标发布者唯一码
    sellStatusName:{
      // 销售状态名称
      type:DataTypes.STRING(20),
      defaultValue:"待售",
    },
    sellStatus:{
      //销售状态:"forSale": "待售", "soldOut": "已售"
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.sellStatus),
      set:function(val){
        this.setDataValue("sellStatus",val);
        this.setDataValue("sellStatusName",uiconfig.config.pdict.sellStatus[val]);
      },
      defaultValue:"1",
    },
    serviceSmallClassTypeName:{
      // 服务小类类型名称
      type:DataTypes.STRING,
    },
    serviceSmallClassType:{
      //服务小类类型:
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.serviceSmallClassType),
      set:function(val){
        this.setDataValue("serviceSmallClassType",val);
        this.setDataValue("serviceSmallClassTypeName",uiconfig.config.pdict.serviceSmallClassType[val]);
      },
      defaultValue:"sbzc",
    },
    isSubProduct:{//是否提报产品,0否，1是
      type:DataTypes.BOOLEAN,
      defaultValue: false,
    },
    productOpUrl:{//产品操作地址
      type:DataTypes.STRING,
    },
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'cms_servicesitem',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
