const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("product", {
    productCata: {
      type:DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(uiconfig.config.pdict.productCata),
      defaultValue: "common",
      set:function(val){
        this.setDataValue("productCataName",uiconfig.config.pdict.productCata[val]);
        this.setDataValue("productCata",val);
      }
    },
    productCataName:{
      type:DataTypes.STRING,
      allowNull: false,
    },
    funcCata: {
      type:DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(uiconfig.config.pdict.funcCata),
      defaultValue: "common",
      set:function(val){
        this.setDataValue("funcCataName",uiconfig.config.pdict.funcCata[val]);
        this.setDataValue("funcCata",val);
      }
    },
    funcCataName:{
      type:DataTypes.STRING,
      allowNull: false,
    },
    style: {
      type:DataTypes.STRING,
      allowNull: true,
    },
    code: {
      type:DataTypes.STRING,
      allowNull: false,
    },
    name: {
      type:DataTypes.STRING,
      allowNull: false,
    },
    imgUrl: {
      type:DataTypes.STRING,
      allowNull: true,
    },
    price: {
      type:DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    desc: {
      type:DataTypes.STRING,
      allowNull: true,
    },
    orderNo:{
      type:DataTypes.INTEGER,
      allowNull: false,
      defaultValue:0
    },
    isPubed:{
      type:DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: true
    }//是否发布
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'p_product',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
