const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("patentinfo", {
    orderNum:DataTypes.STRING(50), //订单号
    app_id:DataTypes.INTEGER,  //平台应用id（创建者平台）
    user_id:DataTypes.INTEGER,  //用户id（创建者）
    onlyCode:DataTypes.STRING(50),   //合伙人唯一码（创建者）
    userName:DataTypes.STRING(50),   //平台用户名（创建者）
    nickName:DataTypes.STRING(50),   //昵称（创建者）
    patentsName:DataTypes.STRING(50),  //发明名称
    patentsType:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.patents_type),
      set:function(val){
        this.setDataValue("patentsType",val);
        this.setDataValue("patentsTypeName",uiconfig.config.pdict.patents_type[val]);
      },
    },   //专利类型（fm发明专利、wg外观专利、syxx实用新型）
    patentsTypeName:DataTypes.STRING(50),   //专利类型名称
    applicantRequireType:DataTypes.STRING,    //申请人要求类型fyjh费用减缓、yqyxq要求优先权、qqtqgk请求提前公开、szsc实质审查、qlyqcx权力要求超项、bmsc保密审查
    status:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.copyright_status),
      set:function(val){
        this.setDataValue("status",val);
        this.setDataValue("statusName",uiconfig.config.pdict.copyright_status[val]);
      },
    },   //状态，1未关联订单，2，已关联订单
    statusName:DataTypes.STRING(50),   //状态名称
    statusProgress:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.statusProgress_status),
      set:function(val){
        this.setDataValue("statusProgress",val);
        this.setDataValue("statusProgressName",uiconfig.config.pdict.statusProgress_status[val]);
      },
    },   //进展状态名称
    statusProgressName:DataTypes.STRING(50),   //进展状态名称
    notes:DataTypes.STRING(255),   //备注
    applierType:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_apply_type),
      set:function(val){
        this.setDataValue("applierType",val);
        this.setDataValue("applierTypeName",uiconfig.config.pdict.tm_apply_type[val]);
      },
    },    //申请类型ent企业，person个人
    applierTypeName:DataTypes.STRING(50),   //申请类型名称
    applyName:DataTypes.STRING(255),   //申请人名称（个人或企业名称）
    applyAddr:DataTypes.STRING(255),    //申请人地址
    mobile:DataTypes.STRING(20),    //联系电话
    zipFile:DataTypes.STRING(255),    //压缩文件（包含申请人身份证、营业执照）
    wgqPic:DataTypes.STRING(255),    //外观前图片
    wghPic:DataTypes.STRING(255),    //外观后图片
    wgzPic:DataTypes.STRING(255),    //外观左图片
    wgyPic:DataTypes.STRING(255),    //外观右图片
    wgfstPic:DataTypes.STRING(255),   //外观府视图片
    wgystPic:DataTypes.STRING(255),   //外观仰视图片
    wgltPic:DataTypes.STRING(255),    //外观立体图片
    opAppId:DataTypes.INTEGER,    //操作者平台应用id
    opUserId:DataTypes.INTEGER,    //操作用户id
    opUserName:DataTypes.STRING(50),   //操作平台用户名
    opNotes:DataTypes.STRING(255),   //操作备注
    customerContact:DataTypes.STRING,//客户联系人
    customerMobile:DataTypes.STRING,//客户联系人手机号
    registrationFormUrl:DataTypes.STRING(255),//登记表（电子）
    technicalFileUrl:DataTypes.STRING(255),//技术交底书（电子）
    //----------------------------------------
    serviceItem_code:DataTypes.STRING(20),//项目编码，如：sbzc
    serviceItem_name:DataTypes.STRING,//项目名称
    channelUserName:DataTypes.STRING(50),//渠道用户名
    channelOrderNum:DataTypes.STRING(50),//渠道方订单号
    totalServiceCharge:DataTypes.DECIMAL(12,2),//服务费总额
    totalPublicExpense:DataTypes.DECIMAL(12,2),//官费总额
    totalPlatformCost:DataTypes.DECIMAL(12,2),//平台费用总额
    totalSum:DataTypes.DECIMAL(12,2),//总额（平台费用+服务费+官费+发票税费）
    platformProfitRatio:DataTypes.DECIMAL(12,2),//平台与渠道的服务费分成比率（如：总额100，字段值30，则平台的利润为30=100*(30/100)，剩下的则为渠道利润）
    channelProfit:DataTypes.DECIMAL(12,2),//渠道服务费利润
    platformProfit:DataTypes.DECIMAL(12,2),//平台服务费利润
    sourceTypeName:DataTypes.STRING(50),//来源类型名称
    sourceType:{
      //来源类型，1PC，2移动商城，4渠道方，默认为2
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.order_source_type),
      defaultValue: "2",
      set:function(val){
        this.setDataValue("sourceType",val);
        this.setDataValue("sourceTypeName",uiconfig.config.pdict.order_source_type[val]);
      },
    },
    sourceNotes:DataTypes.STRING,//来源备注
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'h_patent_info',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
