const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("partnerinfo", {
    userName:DataTypes.STRING,
    applyType: DataTypes.STRING,
    tagInfo:DataTypes.STRING,
    applyName:DataTypes.STRING(1000),
    mobile:DataTypes.STRING,
    tel:DataTypes.STRING,
    workPic:DataTypes.STRING,
    applyProvince:DataTypes.STRING,
    applyCity:DataTypes.STRING,
    applyArea:DataTypes.STRING,
    applyAddr:DataTypes.STRING,
    identityCardPic:DataTypes.STRING,
    identityCard:DataTypes.STRING,
    businessLicensePic:DataTypes.STRING,
    businessLicenseNum:DataTypes.STRING,
    entName:DataTypes.STRING,
    status: {
      type:DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(uiconfig.config.pdict.partnerStatus),
      defaultValue: "1",
    },
    cardNo:DataTypes.STRING,//银行卡号
    realName:DataTypes.STRING,//开户人姓名
    onlyCode:DataTypes.STRING,//帐号唯一码
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'h_partner_info',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
