const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("orderpay", {
     orderNum:DataTypes.STRING,
     payAppId:DataTypes.INTEGER,
     payUserId :DataTypes.INTEGER,
     payUserName:DataTypes.STRING,
     paymentSerialNumber:DataTypes.STRING,//支付流水号
     paymentPlatform:DataTypes.STRING,//支付平台
     payQr:DataTypes.STRING,//支付二维码
     payQrCreateTime:DataTypes.STRING,//支付二维码创建时间戳
     payOrderNum:DataTypes.STRING,//支付订单号
     payTypeName:DataTypes.STRING,
     payType:{
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.payType),
       set:function(val){//支付类型：微信、支付宝、银行卡
         this.setDataValue("payType",val);
         this.setDataValue("payTypeName",uiconfig.config.pdict.payType[val]);
       }
     },
     payResultName:DataTypes.STRING,
     payResult:{///*失败、成功*/
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.payResult),
       set:function(val){
         this.setDataValue("payResult",val);
         this.setDataValue("payResultName",uiconfig.config.pdict.payResult[val]);
       }
     },
     payNum:DataTypes.INTEGER,//支付次数
     payResultInfo:DataTypes.STRING(2000),//支付返回信息
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'h_order_pay',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
