const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("ordercustomerinfo", {
    onlyCode:DataTypes.STRING,
    shopNum:DataTypes.BIGINT,
    customerHeadUrl:DataTypes.STRING,
    customerContact:DataTypes.STRING(50),
    mobile:DataTypes.STRING(20),
    email:DataTypes.STRING(50),
    customerType:{//客户类型，1企业、2个体商户
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_apply_type),
      set:function(val){
        this.setDataValue("type",val);
        this.setDataValue("typeName",uiconfig.config.pdict.tm_apply_type[val]);
      }
    },
    isIndividual:DataTypes.INTEGER,//是否个体工商户
    
    applyName:DataTypes.STRING(1000),
    identityCard:DataTypes.STRING,
    creditCode :DataTypes.STRING,
    applyAddr:DataTypes.STRING,
    businessScope:DataTypes.STRING(2000),
    identityCardPic:DataTypes.STRING,
    businessLicensePic:DataTypes.STRING,
    applyProvince:DataTypes.STRING,
    applyCity:DataTypes.STRING,
    applyArea:DataTypes.STRING,
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'h_order_customer_info',
     validate: {

     },
     indexes:[

     ]
  });
}
