const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("order", {
     app_id:DataTypes.INTEGER,//平台应用id（创建者平台）
     user_id:DataTypes.INTEGER,//用户id（创建者）
     onlyCode:DataTypes.STRING,//合伙人唯一码（创建者）
     userName:DataTypes.STRING,//平台用户名（创建者）
     nickName:DataTypes.STRING,//昵称（创建者）
     orderNum:DataTypes.STRING,//订单号
     invoiceApply:{//发票申请状态:notapply未申请,applied已申请
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.invoiceapply),
       defaultValue: "notapply",
     },
     orderTypeName:DataTypes.STRING,
     orderType:{//订单类型（默认为1），1提报单下单，2自主订单，4批量导入下单，8特殊处理，16代客下单, 32: "渠道下单"
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.order_type),
       set:function(val){
         this.setDataValue("orderType",val);
         this.setDataValue("orderTypeName",uiconfig.config.pdict.order_type[val]);
       }
     },
     itemCode:DataTypes.STRING,//项目操作码
     itemName:DataTypes.STRING,//项目名称
     itemOrderNum:{//项目订单数量（即服务项目的倍数，默认值为1）
       type:DataTypes.INTEGER,
       defaultValue:1
     },
     itemOrderConsumeNum:DataTypes.INTEGER,//项目订单消耗数量（即与项目订单数量相对应）
     isHooked:{//是否被关联，0否，1是
       type:DataTypes.INTEGER,
       defaultValue:0
     },
     orderSourceTypeName:DataTypes.STRING,
     orderSourceType:{//订单来源类型，1:"PC",2:"移动商城",4:"渠道方",8:"beehive渠道"
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.order_source_type),
       set:function(val){
         this.setDataValue("orderSourceType",val);
         this.setDataValue("orderSourceTypeName",uiconfig.config.pdict.order_source_type[val]);
       }
     },
     webPic:DataTypes.STRING,//项目web端图片
     mobilePic:DataTypes.STRING,//项目移动端图片
     totalServiceCharge:DataTypes.DECIMAL(12,2),//服务费总额
     totalPublicExpense:DataTypes.DECIMAL(12,2),//官费总额
     totalPlatformCost:DataTypes.DECIMAL(12,2),//平台费用总额
     totalInvoiceTaxes:DataTypes.DECIMAL(12,2),//发票税费总额（订单总额*7%）
     totalSum:DataTypes.DECIMAL(12,2),//订单总额（平台费用+服务费+官费+发票税费+个人利润+平台利润）
     platformProfit:DataTypes.DECIMAL(12,2),//平台利润
     userProfit:DataTypes.DECIMAL(12,2),//订单创建者用户利润
     userShowOrderStatusName:DataTypes.STRING,
     userShowOrderStatus:{//用户订单页面显示状态1，显示2，用户删除 ，4系统过期删除
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.user_show_order_status),
       set:function(val){
         this.setDataValue("userShowOrderStatus",val);
         this.setDataValue("userShowOrderStatusName",uiconfig.config.pdict.user_show_order_status[val]);
       }
     },
     orderStatusName:DataTypes.STRING,
     orderStatus:{//订单状态，1未付款，2订单取消，4付款成功，8退款处理中，16已退款、32已提报、64审核中
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.order_status),
       set:function(val){
         this.setDataValue("orderStatus",val);
         this.setDataValue("orderStatusName",uiconfig.config.pdict.order_status[val]);
       }
     },
     nclOneCodesNum:DataTypes.INTEGER,//大类件数
     promotionCode:DataTypes.STRING,//优惠码
     reducedRate:DataTypes.INTEGER,//合伙人折扣比率（1-100，之后除以100计算）
     nclCalcIds:DataTypes.STRING,//尼斯核价id（多个以,隔开）
     referrerProfit:DataTypes.DECIMAL(12,2),//推荐人利润 或 推荐成为店主的用户利润
     referrerOnlyCode:DataTypes.STRING,//推荐人合伙人唯一码
     referrerAppId:DataTypes.INTEGER,//推荐人平台应用id
     referrerUserId:DataTypes.INTEGER,//推荐人用户id
     referrerUserName:DataTypes.STRING,//推荐人平台用户名
     referrerNickName:DataTypes.STRING,//推荐人昵称
     shopkeeperProfit:DataTypes.DECIMAL(12,2),//店主利润
     shopOnlyCode:DataTypes.STRING(50),//店铺唯一码（即用户唯一码）
     shopNum:DataTypes.BIGINT,//店铺号
     customerNum:DataTypes.BIGINT,//客户号
     remark:DataTypes.STRING,//备注
     applyName:DataTypes.STRING(1000),//申请人
     platformProfitRatio:DataTypes.DECIMAL(12,2),//平台的分成比率（如：服务费100，字段值30，则平台的利润为30=100*(30/100)，剩下的则为用户服务费）
     referrerProfitRatio:DataTypes.DECIMAL(12,2),//推荐人分成比率（如：用户扣除平台的分成最终的服务费为70，字段值30，则平台的利润为21=70*(30/100)，剩下的则为推荐用户服务费）
     profitRatioTypeName: DataTypes.STRING,
     profitRatioType:{//来源为移动商城有此值，分润类型，platformWork委托作业，selfWork自助作业
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.profitRatioType),
       set:function(val){
         this.setDataValue("profitRatioType",val);
         this.setDataValue("profitRatioTypeName",uiconfig.config.pdict.profitRatioType[val]);
       }
     },
     customerTypeName:DataTypes.STRING,
     customerType:{//联系人类型:"ent":"企业","person":"个人"
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.tm_apply_type),
       set:function(val){
         this.setDataValue("customerType",val);
         this.setDataValue("customerTypeName",uiconfig.config.pdict.tm_apply_type[val]);
       }
     },
     customerContact:DataTypes.STRING,//客户联系人
     customerMobile:DataTypes.STRING,//客户联系人手机号
     itemType:{
       //服务项目类型:
       type:DataTypes.ENUM,
       allowNull: false,
       values: Object.keys(uiconfig.config.pdict.productCata),
       defaultValue: "ip",
     },
     channelName:{//渠道名称
       type:DataTypes.STRING(50),
       defaultValue:"合伙人",
     },
     channelCode:{
       //渠道编码：p_channel表中的channelCode
       type:DataTypes.STRING(20),
       defaultValue:"hhr",
     },
     payAppId:DataTypes.INTEGER,//平台应用id（付款者平台）----------------------------暂未改版--------------------------改版移到h_order_pay
     payUserId :DataTypes.INTEGER,//用户id（付款者）---------------------------------暂未改版-------------------------改版移到h_order_pay
     payUserName:DataTypes.STRING,//平台用户名（付款者）------------------------------暂未改版------------------------改版移到h_order_pay
     payNickName:DataTypes.STRING,//昵称（付款者）-----------------------------------暂未改版-----------------------改版移到h_order_pay
     payQr:DataTypes.STRING,//支付二维码--------------------------------------------暂未改版--------------------------改版移到h_order_pay
     payQrCreateTime:DataTypes.STRING,//支付二维码创建时间戳--------------------------暂未改版--------------------------改版移到h_order_pay
     payOrderNum:DataTypes.STRING,//支付订单号--------------------------------------暂未改版--------------------------改版移到h_order_pay
     parentOrderNum:DataTypes.STRING,//上级订单号-----------------------------------暂未改版--------------------------改版移到h_order_pay
     paymentSerialNumber:DataTypes.STRING,//支付流水号------------------------------暂未改版--------------------------改版移到h_order_pay
     paymentPlatform:DataTypes.STRING,//支付平台类型名称------------------------------------暂未改版--------------------------改版移到h_order_pay
     paymentPlatformType:{
       //支付平台类型:"wx":"微信","offline":"线下"
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.paymentPlatformType),
       set:function(val){
         this.setDataValue("paymentPlatformType",val);
         this.setDataValue("paymentPlatform",uiconfig.config.pdict.paymentPlatformType[val]);
       }
     },
     offlinePayDocument:DataTypes.STRING,//线下支付凭证
     offlineApprovalNotes:DataTypes.STRING,//线下审核备注
     opOnlyCode:DataTypes.STRING(50),//审核操作唯一码
     isSubProduct:{//是否提报产品,0否，1是
      type:DataTypes.BOOLEAN,
      defaultValue: false,
    },
    itemTypeTwoType:{//和是否提报产品结合使用：服务项目类型的二级类型0没有、1软件著作权、2作品著作权
      type:DataTypes.INTEGER,
      defaultValue: 0,
    },    
    channelOrderNum:DataTypes.STRING(50),//渠道订单号
    channelUserId:DataTypes.STRING(50),//渠道用户ID    
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'h_order_info',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
/*
   挂接成功状态变为----订单已付款()
   nclCalcIds
   挂接ids,num,修改档案为已经生成订单,校验多个申请人相同，累计大类数和订单上的大类数量比较
   ---开始提报的时候
   建立两个trade,一个店主利润，推荐人利润，平台利润，更新个人账户余额，平台余额(判断订单来源--进行重新记账)
   查询条件：
     自己交付：来源移动商城、订单的店铺所有者为当前登录人onlyCode，分润类型为自助作业，订单号，
     委托交付：来源移动商城、类型为委托作业，订单号
*/
