const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("invoice", {
    app_id:DataTypes.INTEGER,
    user_id:DataTypes.INTEGER,
    onlyCode:DataTypes.STRING,//合伙人唯一码（创建者）
    orderNum:DataTypes.STRING,//订单号
    totalServiceCharge:DataTypes.DECIMAL(12,2),//服务费总额
    totalPublicExpense:DataTypes.DECIMAL(12,2),//官费总额
    totalPlatformCost:DataTypes.DECIMAL(12,2),//平台费用总额
    totalInvoiceTaxes:DataTypes.DECIMAL(12,2),//发票税费总额（（平台费用+服务费+官费）*7%）
    totalSum:DataTypes.DECIMAL(12,2),//总额（平台费用+服务费+官费+发票税费）
    invoiceType:{
      //发票类型，pt普通发票（电子发票），zy专用发票（纸质发票）
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.invoice_type),
      defaultValue:"pt",
    },
    invoiceHeadUpType:{
      //发票抬头类型，person个人，ent公司
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_apply_type),
    },
    invoiceHeadUp:DataTypes.STRING,//发票抬头
    content:{
      //发票内容
      type:DataTypes.STRING,
      defaultValue:"服务费",
    },
    mobile:DataTypes.STRING,//收票人手机号
    email:DataTypes.STRING,//收票人邮箱
    address:DataTypes.STRING,//申请地址
    applyProvince:DataTypes.STRING,//省
    applyCity:DataTypes.STRING,//市
    applyArea:DataTypes.STRING,//申请地区
    applyAddr:DataTypes.STRING,//申请地址
    applytelephone:DataTypes.STRING,
    expressCompany:DataTypes.STRING,
    expressNum:DataTypes.STRING,
    expressDate:DataTypes.STRING,
    opAppId:DataTypes.INTEGER,
    opUserId:DataTypes.INTEGER,
    opOnlyCode:DataTypes.STRING,//合伙人唯一码（操作者）
    taxpayerID:DataTypes.STRING,
    statusName:{
      type:DataTypes.STRING,
      defaultValue:"已提交",
    },
    status:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.invoice_status),
      set:function(val){
        this.setDataValue("status",val);
        this.setDataValue("statusName",uiconfig.config.pdict.invoice_status[val]);
      },
      defaultValue:"submitted",
    },
    qrCodeUrl:DataTypes.STRING,
    electronicInvoiceUrl:DataTypes.STRING,
    bankAddrNum:DataTypes.STRING,
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'h_invoice',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
