const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  var cipherkey=0b11111100000000001111110000000000;
  var precision=100;
  function toCipher(n){
    var m=n * precision;
    var rtn=m ^ cipherkey;
    return rtn;
  }
  function decipherToNum(m){
    var rtn=m ^ cipherkey;
    rtn=rtn / precision;
    return rtn;
  }
  return db.define("individualincometax", {
     app_id:DataTypes.INTEGER,//平台应用id（创建者平台）
     user_id:DataTypes.INTEGER,//用户id（创建者）
     onlyCode:DataTypes.STRING,//合伙人唯一码（创建者）
     userName:DataTypes.STRING,//平台用户名（创建者）
     nickName:DataTypes.STRING,//昵称（创建者）

     employeeName:DataTypes.STRING,//员工姓名
     employeeNum:DataTypes.STRING,//员工工号
     statisticalTime:DataTypes.STRING,//统计/测试日期
     statisticalYear:DataTypes.STRING,//统计/测试年
     statisticalMonth:DataTypes.STRING,//统计/测试月
     statisticalCompanyName:DataTypes.STRING,//统计公司名称
     shareOnlyCode:DataTypes.STRING,//分享唯一码
     taxTypeName:DataTypes.STRING,
     taxType:{//个税类型
       type:DataTypes.ENUM,
       defaultValue:'gzxj',
       values: Object.keys(uiconfig.config.pdict.taxType),
       set:function(val){
         this.setDataValue("taxType",val);
         this.setDataValue("taxTypeName",uiconfig.config.pdict.taxType[val]);
       }
     },
     answer:DataTypes.TEXT,//试题答案
      // {
      //   	test1:{
      //   		title1:"", title2:"", title3:"", title4:"",
      //   	},
      //   	test2:{
      //   		title1:"", title2:"", title3:"",
      //   	},
      //   	test3:{
      //   		title1:"", title2:"", title3:"", title4:"",
      //   	},
      //   	test4:{
      //   		title1:"", title2:"", title3:"",
      //   	},
      //   	test5:{
      //   		title1:"", title2:"", title3:"",
      //   	}
      // }
      preTaxSalary:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("preTaxSalary",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('preTaxSalary');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },// 税前薪资
      postTaxSalary:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("postTaxSalary",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('postTaxSalary');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },// 税后薪资
      insuranceAndFund:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("insuranceAndFund",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('insuranceAndFund');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },// 五险一金
      childrenEducation:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("childrenEducation",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('childrenEducation');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },// 专项扣除-子女教育
      continuingEducation:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("continuingEducation",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('continuingEducation');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },// 专项扣除-继续教育
      interestExpense:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("interestExpense",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('interestExpense');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },// 专项扣除-房贷利息
      housingRent:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("housingRent",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('housingRent');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },// 专项扣除-住房租金
      supportElderly:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("supportElderly",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('supportElderly');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },// 专项扣除-赡养老人
      illnessMedicalTreatment:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("illnessMedicalTreatment",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('illnessMedicalTreatment');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },// 专项扣除-大病医疗
      personalIncomeTax:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("personalIncomeTax",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('personalIncomeTax');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },// 应纳个税

      taxRate:{
        type:DataTypes.INTEGER,
        set:function(val){
          this.setDataValue("taxRate",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('taxRate');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },//税率
      deductionNumber:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("deductionNumber",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('deductionNumber');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },//扣除数
      specialDeduction:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("specialDeduction",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('specialDeduction');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },// 专项扣除总额
      exemptionAmount:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("exemptionAmount",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('exemptionAmount');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },// 免征额
      accuPreTaxSalary:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("accuPreTaxSalary",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('accuPreTaxSalary');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },//累计税前薪资
      accuInsuranceAndFund:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("accuInsuranceAndFund",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('accuInsuranceAndFund');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },//累计五险一金
      accuExemptionAmount:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("accuExemptionAmount",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('accuExemptionAmount');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },// 累计免征额
      accuSpecialDeduction:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("accuSpecialDeduction",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('accuSpecialDeduction');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },// 累计专项扣除
      accuPersonalIncomeTax:{
        type:DataTypes.DECIMAL(14,2),
        set:function(val){
          this.setDataValue("accuPersonalIncomeTax",toCipher(val));
        },
        get:function()  {
          var x = this.getDataValue('accuPersonalIncomeTax');
          // 'this' allows you to access attributes of the instance
          return decipherToNum(x);
        },
        defaultValue:toCipher(0)
      },// 累计应纳个税
      status:{
        type:DataTypes.ENUM,
        defaultValue:'0',
        values: Object.keys(uiconfig.config.pdict.iit_status),
        set:function(val){
          this.setDataValue("status",val);
          this.setDataValue("statusName",uiconfig.config.pdict.iit_status[val]);
        },
      },
      statusName:DataTypes.STRING(50),
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'h_individual_income_tax',
     validate: {

     },
     indexes:[

     ]
  });
}
