const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("customerrollpic", {
    customerNum:DataTypes.BIGINT,//客户号
    title:DataTypes.STRING,//标题
    linkUrl:DataTypes.STRING,//链接地址
    notes:DataTypes.STRING,//备注信息
    isPubed:DataTypes.INTEGER,//是否发布，0不发布，1发布，默认为0
    sort:{
      type:DataTypes.DOUBLE,
      defaultValue:1,
    },
    picType:{
      //图片类型：roll滚动图片、placard海报图片
      type:DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(uiconfig.config.pdict.picType),
      defaultValue: "roll",
    },
    picCategory:{
      //图片分类："ip": "商标", "ic": "版权", "pa": "专利", "common": "增值"
      type:DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(uiconfig.config.pdict.picCategory),
      defaultValue: "ip",
    },
    jumpUrl:DataTypes.STRING,//跳转链接
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'b_customer_roll_pic',
     validate: {
     }
  });
}
