const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("customerinfo", {
      customerTypeName:DataTypes.STRING(50),//类型名称
      customerType:{
        //类型ent企业，person个人
        type:DataTypes.ENUM,
        values: Object.keys(uiconfig.config.pdict.tm_apply_type),
        set:function(val){
          this.setDataValue("customerType",val);
          this.setDataValue("customerTypeName",uiconfig.config.pdict.tm_apply_type[val]);
        }
      },
      name:DataTypes.STRING(1000),//客户名称（公司或个体名称）
      identityCard:DataTypes.STRING,//身份证信息（类型为个体商户有此值）
      creditCode :DataTypes.STRING,//信用代码
      area:DataTypes.STRING,//地区
      addr:DataTypes.STRING,//地址
      businessScope:DataTypes.STRING(2000),//经营范围
      province:DataTypes.STRING,//省
      city:DataTypes.STRING,//市
      identityCardPic:DataTypes.STRING,//身份证附件
      businessLicensePic:DataTypes.STRING,//营业执照附件
      mobile:DataTypes.STRING(20),//联系电话
      headUrl:DataTypes.STRING(255),//客户头像
      customerNum:DataTypes.BIGINT,//客户号
      sort:{
        type:DataTypes.DOUBLE,
        defaultValue:1,
      },
      notes:DataTypes.STRING,//备注信息
      customerNotes:DataTypes.STRING,//客户备注信息
      customerOnlyCode:DataTypes.STRING,//客户onlycode
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'p_customer_info',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
