const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("copyrightinfo", {
    orderNum:DataTypes.STRING(50),
    app_id:DataTypes.INTEGER,
    user_id:DataTypes.INTEGER,
    onlyCode:DataTypes.STRING(50),
    userName:DataTypes.STRING(50),
    nickName:DataTypes.STRING(50),
    copyrightType:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.copyright_type),
      set:function(val){
        this.setDataValue("copyrightType",val);
        this.setDataValue("copyrightTypeName",uiconfig.config.pdict.copyright_type[val]);
      },
    },
    copyrightTypeName:DataTypes.STRING(50),
    compositionType:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.composition_type),
      set:function(val){
        this.setDataValue("compositionType",val);
        this.setDataValue("compositionTypeName",uiconfig.config.pdict.composition_type[val]);
      },
    },
    compositionTypeName:DataTypes.STRING(50),
    status:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.copyright_status),
      set:function(val){
        this.setDataValue("status",val);
        this.setDataValue("statusName",uiconfig.config.pdict.copyright_status[val]);
      },
    },
    statusName:DataTypes.STRING(50),
    statusProgress:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.statusProgress_status),
      set:function(val){
        this.setDataValue("statusProgress",val);
        this.setDataValue("statusProgressName",uiconfig.config.pdict.statusProgress_status[val]);
      },
    },
    statusProgressName:DataTypes.STRING(50),
    notes:DataTypes.STRING(255),
    applierTypeName:DataTypes.STRING(50),
    applierType:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_apply_type),
      set:function(val){
        this.setDataValue("applierType",val);
        this.setDataValue("applierTypeName",uiconfig.config.pdict.tm_apply_type[val]);
      },
    },
    applyName:DataTypes.STRING(255),
    mobile:DataTypes.STRING(20),
    customerContact:DataTypes.STRING(20),//客户联系人
    customerMobile:DataTypes.STRING(20),//客户联系人手机号
    identityCardPic:DataTypes.STRING(255),
    businessLicensePic:DataTypes.STRING(255),
    specimenPic:DataTypes.STRING(255),
    registrationDocument:DataTypes.STRING(255),
    codeDocument:DataTypes.STRING(255),
    instructionBookDocument:DataTypes.STRING(255),
    applyDocument:DataTypes.STRING(255),
    opAppId:DataTypes.INTEGER,
    opUserId:DataTypes.INTEGER,
    opUserName:DataTypes.STRING(50),
    opNotes:DataTypes.STRING(255),
//-------------------------------------------
    serviceItem_code:DataTypes.STRING(20),//项目编码，如：sbzc
    serviceItem_name:DataTypes.STRING,//项目名称
    channelUserName:DataTypes.STRING(50),//渠道用户名
    channelOrderNum:DataTypes.STRING(50),//渠道方订单号
    totalServiceCharge:DataTypes.DECIMAL(12,2),//服务费总额
    totalPublicExpense:DataTypes.DECIMAL(12,2),//官费总额
    totalPlatformCost:DataTypes.DECIMAL(12,2),//平台费用总额
    totalSum:DataTypes.DECIMAL(12,2),//总额（平台费用+服务费+官费+发票税费）
    platformProfitRatio:DataTypes.DECIMAL(12,2),//平台与渠道的服务费分成比率（如：总额100，字段值30，则平台的利润为30=100*(30/100)，剩下的则为渠道利润）
    channelProfit:DataTypes.DECIMAL(12,2),//渠道服务费利润
    platformProfit:DataTypes.DECIMAL(12,2),//平台服务费利润
    sourceTypeName:DataTypes.STRING(50),//来源类型名称
    sourceType:{
      //来源类型，1PC，2移动商城，4渠道方，默认为2
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.order_source_type),
      defaultValue: "2",
      set:function(val){
        this.setDataValue("sourceType",val);
        this.setDataValue("sourceTypeName",uiconfig.config.pdict.order_source_type[val]);
      },
    },
    sourceNotes:DataTypes.STRING,//来源备注
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'h_copyright_info',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
