const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("channeltm", {
     orderNum:DataTypes.STRING,
     tmTypeName:DataTypes.STRING,
     tmType:{
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.tm_type),
       set:function(val){
         this.setDataValue("tmType",val);
         this.setDataValue("tmTypeName",uiconfig.config.pdict.tm_type[val]);
       }
     },
     tmFormTypeName:DataTypes.STRING,
     tmFormType:{
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.tm_form_type),
       set:function(val){
         this.setDataValue("tmFormType",val);
         this.setDataValue("tmFormTypeName",uiconfig.config.pdict.tm_form_type[val]);
       }
     },
     caseTypeName:{
       type:DataTypes.STRING,
       default:"商标注册"
     },
     caseType:{
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.caseType),
       defaultValue: "sbzc",
       set:function(val){
         this.setDataValue("caseType",val);
         this.setDataValue("caseTypeName",uiconfig.config.pdict.caseType[val]);
       }
     },
     nclOneCodes:DataTypes.STRING(20),
     nclSmallCodes:DataTypes.TEXT,
     tmName:DataTypes.STRING(500),
     picUrl:DataTypes.STRING(500),
     tmNameEn:DataTypes.STRING(1000),
     known :DataTypes.BOOLEAN,
     tmValue:DataTypes.DECIMAL(12,2),
     coOwner:DataTypes.STRING,
     submitTime:DataTypes.DATE ,
     proxyCode :DataTypes.STRING,
     tmRegistNum :DataTypes.STRING,
     sealAuthorizeStuff:DataTypes.STRING(500),
     serviceItem_code:DataTypes.STRING(20),
     serviceItem_name:DataTypes.STRING,
     tmStatusName:DataTypes.STRING,
     tmStatus:{
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.tm_submit_status),
       set:function(val){
         this.setDataValue("tmStatus",val);
         this.setDataValue("tmStatusName",uiconfig.config.pdict.tm_submit_status[val]);
       }
     },
     voiceUrl:DataTypes.STRING,
     descUrl:DataTypes.STRING,
     colorizedPicUrl:DataTypes.STRING,
     remarkInfo:DataTypes.STRING,//备注信息
     app_code:DataTypes.BIGINT,//操作备注信息-----del
     channelOrderNum:DataTypes.STRING(50),
     channelUserName:DataTypes.STRING(50),
     userName:DataTypes.STRING(50),
     totalServiceCharge:DataTypes.DECIMAL(12,2),
     totalPublicExpense:DataTypes.DECIMAL(12,2),
     totalPlatformCost:DataTypes.DECIMAL(12,2),
     totalSum:DataTypes.DECIMAL(12,2),
     platformProfitRatio:DataTypes.DECIMAL(12,2),
     channelProfit:DataTypes.DECIMAL(12,2),
     platformProfit:DataTypes.DECIMAL(12,2),
     applyName:DataTypes.STRING(1000),
     customerContact:DataTypes.STRING(50),
     customerMobile:DataTypes.INTEGER(50),
     opAppId:DataTypes.INTEGER,
     opUserId:DataTypes.INTEGER,
     opUserName:DataTypes.STRING(50),
     opOnlyCode:DataTypes.STRING(50),
     opRemarkInfo:DataTypes.STRING(200),
     clientIp:DataTypes.STRING(20),
     notes:DataTypes.STRING(200),
     param1:DataTypes.STRING,//备用字段-----del
     tmSourceTypeName:{
       type:DataTypes.STRING(50),
       default:"PC"
     },
     tmSourceType:{
       type:DataTypes.ENUM,
       values: Object.keys(uiconfig.config.pdict.tmSourceType),
       defaultValue: "1",
       set:function(val){
         this.setDataValue("tmSourceType",val);
         this.setDataValue("tmSourceTypeName",uiconfig.config.pdict.tmSourceType[val]);
       }
     },
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'h_channel_tm',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
