const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);

module.exports = (db, DataTypes) => {
  return db.define("channelmanageallot", {
    // channel_id           int comment '渠道id',  自动生成
    // user_id   自动生成
    app_id:DataTypes.INTEGER, // 用户应用id
    channelName:DataTypes.STRING(20), // 渠道名称
    channelCode:DataTypes.STRING(50),   // 渠道码
    chanceType:{
      //商机类型: "ip": "商标", "ic": "版权", "pa": "专利", "common": "增值", "icbc": "工商" “iso":"海外服务”
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.chanceType),
      set:function(val){
        this.setDataValue("chanceType",val);
        this.setDataValue("chanceTypeName",uiconfig.config.pdict.chanceType[val]);
      }
    },
    chanceTypeName:DataTypes.STRING(50),    // 商机类型名称
    noticeType:{
      // 通知类型: "sms": "短信", "email": "邮件","wechat":"微信"
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.noticeType),
      set:function(val){
        this.setDataValue("noticeType",val);
        this.setDataValue("noticeTypeName",uiconfig.config.pdict.noticeType[val]);
      }
    },
    noticeTypeName:DataTypes.STRING(50),  // 通知类型名称
    businessOwner:DataTypes.STRING(50),   // 业务负责人
    mobile:DataTypes.STRING(20),//手机
    email:DataTypes.STRING(50), // 邮箱
    openId:DataTypes.STRING(50),// 微信
    leaderMobile:DataTypes.STRING(20),// 领导手机号
    leaderId:DataTypes.INTEGER, // 领导id
    leaderOpenId:DataTypes.STRING(50),// 领导微信openId
    isEnabled:{//是否启用，0否，1是 默认1
      type:DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: true,
    },
    isOrderReceiving:{  // 是否接单0否1是，默认1
      type:DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: true,
    },
    weight:DataTypes.DECIMAL(12,2), // 分配权重
    allotCount:DataTypes.DECIMAL(12,2), // 分配次数
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'c_channel_manage_allot',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
