const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("channel", {
    opAppId:DataTypes.INTEGER,
    opUserId:DataTypes.INTEGER,
    opUserName:DataTypes.STRING(50),
    opOnlyCode:DataTypes.STRING(50),
    opClientIp:DataTypes.STRING(20),
    channelName:DataTypes.STRING(50),//渠道名称
    channelCode:DataTypes.STRING(20),//渠道编码
    wxAppId:DataTypes.STRING,//项目操作码
    icon:DataTypes.STRING(300),  // 头像点击链接
    iconLink:DataTypes.STRING(300),  // 图像点击链接
    qrcodeurl:DataTypes.STRING(300),  // 图像点击链接
    moreShop:{//支持多店，0否，1是
      type:DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    isEnabled:{//分享时是否渠道店铺名称，0否，1是
      type:DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    channelShopName:DataTypes.STRING(20),//渠道店铺名称
    isPubed:{//是否可以交易，0不发布，1发布，默认为1
      type:DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: true,
    },
    sort:{//排序
      type:DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 1,
    },
    everySingleProfit:{
      type:DataTypes.DECIMAL(12,2),//渠道每单利润或渠道分成比率
      defaultValue:0.00,
    },
    totalChannelProfit:{
      type:DataTypes.DECIMAL(12,2),//渠道总利润
      defaultValue:0.00,
    },
    totalPlatformProfit:{
      type:DataTypes.DECIMAL(12,2),//平台总利润
      defaultValue:0.00,
    },
    profitTypeName:DataTypes.STRING(50),//渠道利润类型名称
    profitType:{
      //渠道利润类型:1: 比例分成, 2: 每单分成
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.channelProfitType),
      defaultValue: "1",
      set:function(val){
        this.setDataValue("profitType",val);
        this.setDataValue("profitTypeName",uiconfig.config.pdict.channelProfitType[val]);
      },
    },
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'p_channel',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
