const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("calculateprice", {
    code:DataTypes.STRING,
    app_id:DataTypes.INTEGER,
    user_id:DataTypes.INTEGER,
    name:DataTypes.STRING,
    nclOneCodes:DataTypes.STRING,
    nclSmallCodes:DataTypes.TEXT,
    customerContact:DataTypes.STRING,
    mobile:DataTypes.STRING,
    email:DataTypes.STRING,
    nclServiceCharge:DataTypes.DECIMAL(12,2),
    nclTotalPublicExpense:DataTypes.DECIMAL(12,2),
    invoiceTaxes:DataTypes.DECIMAL(12,2),
    totalPlatformCost:DataTypes.DECIMAL(12,2),
    tmTypeName:{
      type:DataTypes.STRING,
      defaultValue:'普通商标',
    },
    tmType:{
      type:DataTypes.ENUM,
      defaultValue:"p",
      values: Object.keys(uiconfig.config.pdict.tm_type),
      set:function(val){
        this.setDataValue("tmType",val);
        this.setDataValue("tmTypeName",uiconfig.config.pdict.tm_type[val]);
      }
    },
    tmFormTypeName:{
      type:DataTypes.STRING,
      defaultValue:'文字',
    },
    tmFormType: {
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_form_type),
      defaultValue:"3",
      set:function(val){
        this.setDataValue("tmFormType",val);
        this.setDataValue("tmFormTypeName",uiconfig.config.pdict.tm_form_type[val]);
      }
    },
    tmName:DataTypes.STRING,
    picUrl:DataTypes.STRING,
    colorizedPicUrl:DataTypes.STRING,
    remark:DataTypes.STRING,
    userDel:DataTypes.INTEGER,
    status:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.ncl_calc_status),
      defaultValue:"1",
      set:function(val){
        this.setDataValue("status",val);
      }
    },
    calcTypeName:{
      type:DataTypes.STRING,
      defaultValue:'自主创建',
    },
    calcType:{
      type:DataTypes.ENUM,
      defaultValue:"1",
      values: Object.keys(uiconfig.config.pdict.ncl_calc_calcType),
      set:function(val){
        this.setDataValue("calcType",val);
        this.setDataValue("calcTypeName",uiconfig.config.pdict.ncl_calc_calcType[val]);
      }
    },
    orderNum:DataTypes.STRING,
    tmExplain:DataTypes.STRING,
    applyName:DataTypes.STRING,
    createAuthorizeStuff:DataTypes.STRING,
    zipCode:DataTypes.STRING,
    applyAddr:DataTypes.STRING,
    creditCode:DataTypes.STRING,//信用代码
    totalSum:DataTypes.DECIMAL(12,2),//总价
    identityCard:DataTypes.STRING,//身份证号
    type:{
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_apply_type),
      set:function(val){
        this.setDataValue("type",val);
      }
    },//申请类型
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'h_ncl_calc',
     validate: {

     },
     indexes:[

     ]
  });
}
