const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("buybusinesslicense", {
    // channel_id配置关系引用
    serviceTypeOneId: DataTypes.INTEGER,
    serviceTypeTwoId: DataTypes.INTEGER,
    opCode:{//操作编码
      type:DataTypes.STRING(50),
      allowNull:false,
      unique: true
    },
    guidePrice:{//指导价
      type:DataTypes.DECIMAL(12,2),
      defaultValue:0.00,
    },
    registerCapital:{//注册资本
      type:DataTypes.DECIMAL(12,2),
      defaultValue:0.00,
    },
    serviceScope: DataTypes.STRING(500),//服务范围
    registerDay:DataTypes.DATE,//注册日期
    registerProvince: DataTypes.STRING(50),//注册省份
    registerCity: DataTypes.STRING(50),//注册城市
    registerArea: DataTypes.STRING(50),//注册地区
    registerAddr: DataTypes.STRING,//注册地址
    sort:{//指导价
      type:DataTypes.INTEGER,
      defaultValue:0,
    },
    channelCode: DataTypes.STRING(50),//渠道编码：p_channel表中的channelCode
    hotline: DataTypes.STRING(20),//咨询电话
    notes: DataTypes.STRING,//备注信息
    opOnlyCode: DataTypes.STRING(50),//操作人唯一编码
    companyPropertyName:{//公司性质名称
      type:DataTypes.STRING(50),
      defaultValue:"小规模",
    },
    companyProperty:{
      //公司性质，1小规模、2一般
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.companyProperty),
      set:function(val){
        this.setDataValue("companyProperty",val);
        this.setDataValue("companyPropertyName",uiconfig.config.pdict.companyProperty[val]);
      },
      defaultValue:"1",
    },
    isPubed:{//是否可以交易，0不发布，1发布，默认为0
      type:DataTypes.INTEGER,
      defaultValue:0,
    },
    isRecommend:{//是否推荐：0: 否, 1: 是
      type:DataTypes.INTEGER,
      defaultValue:0,
    },
    isNegotiable:{//是否面议：0: 否, 1: 是
      type:DataTypes.INTEGER,
      defaultValue:0,
    },
    changeServiceName:{//变更服务名称
      type:DataTypes.STRING(50),
      defaultValue:"包变更",
    },
    changeService:{
      //变更服务，1包变更、2买家变更
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.changeService),
      set:function(val){
        this.setDataValue("changeService",val);
        this.setDataValue("changeServiceName",uiconfig.config.pdict.changeService[val]);
      },
      defaultValue:"1",
    },
    registeredCapitalName:{//变更服务名称
      type:DataTypes.STRING(50),
      defaultValue:"小于100万",
    },
    registeredCapital:{
      //注册资本，1：小于100万、2:：100-500万、4：501-1000万、8：1001-5000万、16：大于1000万
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.registeredCapital),
      set:function(val){
        this.setDataValue("registeredCapital",val);
        this.setDataValue("registeredCapitalName",uiconfig.config.pdict.registeredCapital[val]);
      },
      defaultValue:"1",
    },
    onlyCode: DataTypes.STRING(50),//发布者唯一码
    companyOnlyCode: DataTypes.STRING(50),//公司的唯一码
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'yz_buy_business_license',
     validate: {

     },
     indexes:[

     ]
  });
}
