const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("businesslicense", {
    // channel_id配置关系引用
    serviceTypeOneId: DataTypes.INTEGER,
    serviceTypeTwoId: DataTypes.INTEGER,
    opCode:{//操作编码
      type:DataTypes.STRING(50),
      allowNull:false,
      unique: true
    },
    code:{//执照编码
      type:DataTypes.STRING(20),
    },
    name:{//执照名称
      type:DataTypes.STRING,
    },
    guidePrice:{//指导价
      type:DataTypes.DECIMAL(12,2),
      defaultValue:0.00,
    },
    guidePriceScope : DataTypes.INTEGER,
    registerCapital:{//注册资本
      type:DataTypes.DECIMAL(12,2),
      defaultValue:0.00,
    },
    serviceScope: DataTypes.STRING(500),//服务范围
    webPic:DataTypes.STRING,//web端图片
    mobilePic:DataTypes.STRING, //移动端图片
    mobileContentImg:DataTypes.STRING, //移动内容图片
    answerConent:DataTypes.STRING, //问答内容图片
    intro:DataTypes.STRING(500), //介绍
    registerDay:DataTypes.DATE,//注册日期
    businessEndDay:DataTypes.DATE,//营业截至日期
    registerProvince: DataTypes.STRING(50),//注册省份
    registerCity: DataTypes.STRING(50),//注册城市
    registerArea: DataTypes.STRING(50),//注册地区
    registerAddr: DataTypes.STRING,//注册地址
    sort:{//指导价
      type:DataTypes.INTEGER,
      defaultValue:0,
    },
    channelCode: DataTypes.STRING(50),//渠道编码：p_channel表中的channelCode
    hotline: DataTypes.STRING(20),//咨询电话
    notes: DataTypes.STRING,//备注信息
    opOnlyCode: DataTypes.STRING(50),//操作人唯一编码
    companyPropertyName:{//公司性质名称
      type:DataTypes.STRING(50),
      defaultValue:"小规模",
    },
    companyProperty:{
      //公司性质，1小规模、2一般
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.companyProperty),
      set:function(val){
        this.setDataValue("companyProperty",val);
        this.setDataValue("companyPropertyName",uiconfig.config.pdict.companyProperty[val]);
      },
      defaultValue:"1",
    },
    isPubed:{//是否可以交易，0不发布，1发布，默认为0
      type:DataTypes.INTEGER,
      defaultValue:0,
    },
    isRecommend:{//是否推荐：0: 否, 1: 是
      type:DataTypes.INTEGER,
      defaultValue:0,
    },
    isNegotiable:{//是否面议：0: 否, 1: 是
      type:DataTypes.INTEGER,
      defaultValue:0,
    },
    isBankAccount:{//银行是否开户
      type:DataTypes.INTEGER,
      defaultValue:0,
    },
    isNormalOperation:{//经营是否正常
      type:DataTypes.INTEGER,
      defaultValue:0,
    },
    isLocalTax:{//过地税报道
      type:DataTypes.INTEGER,
      defaultValue:0,
    },
    isFiscal:{//是否有税控
      type:DataTypes.INTEGER,
      defaultValue:0,
    },
    isKeepAccountsTax:{//记账报税是否正常
      type:DataTypes.INTEGER,
      defaultValue:0,
    },
    invoiceVersionName:{//发票版本名称
      type:DataTypes.STRING(50),
      defaultValue:"无发票",
    },
    invoiceVersion:{
      //发票版本，1十万版、万元版、百万版
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.invoiceVersion),
      set:function(val){
        this.setDataValue("invoiceVersion",val);
        this.setDataValue("invoiceVersionName",uiconfig.config.pdict.invoiceVersion[val]);
      },
      defaultValue:"4",
    },
    isAddrCharge:{//地址是否收费
      type:DataTypes.INTEGER,
      defaultValue:0,
    },
    changeServiceName:{//变更服务名称
      type:DataTypes.STRING(50),
      defaultValue:"包变更",
    },
    changeService:{
      //变更服务，1包变更、2买家变更
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.changeService),
      set:function(val){
        this.setDataValue("changeService",val);
        this.setDataValue("changeServiceName",uiconfig.config.pdict.changeService[val]);
      },
      defaultValue:"1",
    },
    publishedSourcesName:{//发票版本名称
      type:DataTypes.STRING(50),
      defaultValue:"公司",
    },
    publishedSources:{
      //发布来源，1公司、2个人
      type:DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.publishedSources),
      set:function(val){
        this.setDataValue("publishedSources",val);
        this.setDataValue("publishedSourcesName",uiconfig.config.pdict.publishedSources[val]);
      },
      defaultValue:"1",
    },
    onlyCode: DataTypes.STRING(50),//发布者唯一码
    companyOnlyCode: DataTypes.STRING(50),//公司的唯一码
    legalPerson: DataTypes.STRING(50),//法人
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'yz_business_license',
     validate: {

     },
     indexes:[

     ]
  });
}
